/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.util.ModelUtils;

public class TemplateLib {
    public static Iterator<Quad> template(List<Quad> quads, Node dftGraph, Iterator<Binding> bindings) {
        if (quads == null || quads.isEmpty()) {
            return null;
        }
        quads = TemplateLib.remapDefaultGraph(quads, dftGraph);
        return TemplateLib.calcQuads(quads, bindings);
    }

    public static List<Quad> remapDefaultGraph(List<Quad> quads, Node dftGraph) {
        if (quads == null || quads.isEmpty()) {
            return quads;
        }
        if (dftGraph == null || Quad.isDefaultGraph(dftGraph)) {
            return quads;
        }
        Stream<Quad> remappedStream = quads.stream().map(q -> !q.isDefaultGraph() ? q : new Quad(dftGraph, q.getSubject(), q.getPredicate(), q.getObject()));
        return remappedStream.collect(Collectors.toList());
    }

    public static Iterator<Triple> calcTriples(final List<Triple> triples, Iterator<Binding> bindings) {
        Function<Binding, Iterator<Triple>> mapper = new Function<Binding, Iterator<Triple>>(){
            Map<Node, Node> bNodeMap = new HashMap<Node, Node>();

            @Override
            public Iterator<Triple> apply(Binding b) {
                this.bNodeMap.clear();
                ArrayList<Triple> tripleList = new ArrayList<Triple>(triples.size());
                for (Triple triple : triples) {
                    Triple q = TemplateLib.subst(triple, b, this.bNodeMap);
                    if (!q.isConcrete() || !ModelUtils.isValidAsStatement(q.getSubject(), q.getPredicate(), q.getObject())) continue;
                    tripleList.add(q);
                }
                return tripleList.iterator();
            }
        };
        return Iter.flatMap(bindings, mapper);
    }

    public static Iterator<Quad> calcQuads(final List<Quad> quads, Iterator<Binding> bindings) {
        Function<Binding, Iterator<Quad>> mapper = new Function<Binding, Iterator<Quad>>(){
            Map<Node, Node> bNodeMap = new HashMap<Node, Node>();

            @Override
            public Iterator<Quad> apply(Binding b) {
                this.bNodeMap.clear();
                ArrayList<Quad> quadList = new ArrayList<Quad>(quads.size());
                for (Quad quad : quads) {
                    Quad q = TemplateLib.subst(quad, b, this.bNodeMap);
                    if (!q.isConcrete()) continue;
                    quadList.add(q);
                }
                return quadList.iterator();
            }
        };
        return Iter.flatMap(bindings, mapper);
    }

    public static Quad subst(Quad quad, Binding b, Map<Node, Node> bNodeMap) {
        Node g = quad.getGraph();
        Node s = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        Node g1 = g;
        Node s1 = s;
        Node p1 = p;
        Node o1 = o;
        if (g1.isBlank() || Var.isBlankNodeVar(g1)) {
            g1 = TemplateLib.newBlank(g1, bNodeMap);
        }
        if (s1.isBlank() || Var.isBlankNodeVar(s1)) {
            s1 = TemplateLib.newBlank(s1, bNodeMap);
        }
        if (p1.isBlank() || Var.isBlankNodeVar(p1)) {
            p1 = TemplateLib.newBlank(p1, bNodeMap);
        }
        if (o1.isBlank() || Var.isBlankNodeVar(o1)) {
            o1 = TemplateLib.newBlank(o1, bNodeMap);
        }
        Quad q = quad;
        if (s1 != s || p1 != p || o1 != o || g1 != g) {
            q = new Quad(g1, s1, p1, o1);
        }
        Quad q2 = Substitute.substitute(q, b);
        return q2;
    }

    public static Triple subst(Triple triple, Binding b, Map<Node, Node> bNodeMap) {
        Node s = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        Node s1 = s;
        Node p1 = p;
        Node o1 = o;
        if (s1.isBlank() || Var.isBlankNodeVar(s1)) {
            s1 = TemplateLib.newBlank(s1, bNodeMap);
        }
        if (p1.isBlank() || Var.isBlankNodeVar(p1)) {
            p1 = TemplateLib.newBlank(p1, bNodeMap);
        }
        if (o1.isBlank() || Var.isBlankNodeVar(o1)) {
            o1 = TemplateLib.newBlank(o1, bNodeMap);
        }
        Triple t = triple;
        if (s1 != s || p1 != p || o1 != o) {
            t = Triple.create(s1, p1, o1);
        }
        Triple t2 = Substitute.substitute(t, b);
        return t2;
    }

    private static Node newBlank(Node n, Map<Node, Node> bNodeMap) {
        if (!bNodeMap.containsKey(n)) {
            bNodeMap.put(n, NodeFactory.createBlankNode());
        }
        return bNodeMap.get(n);
    }
}

