/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.protobuf;

import java.io.OutputStream;
import java.io.Writer;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.WriterGraphRIOT;
import org.apache.jena.riot.protobuf.ProtobufRDF;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFOps;
import org.apache.jena.sparql.util.Context;

public class WriterGraphProtobuf
implements WriterGraphRIOT {
    private final boolean withValues;

    public WriterGraphProtobuf(RDFFormat fmt) {
        this.withValues = RDFFormat.RDF_PROTO_VALUES.equals(fmt);
    }

    @Override
    public Lang getLang() {
        return RDFLanguages.RDFPROTO;
    }

    @Override
    public void write(Writer out, Graph graph, PrefixMap prefixMap, String baseURI, Context context2) {
        throw new NotImplemented("Writing binary data to a java.io.Writer is not supported. Please use an OutputStream");
    }

    @Override
    public void write(OutputStream out, Graph graph, PrefixMap prefixMap, String baseURI, Context context2) {
        StreamRDF stream = ProtobufRDF.streamToOutputStream(out, this.withValues);
        stream.start();
        StreamRDFOps.graphToStream(graph, stream);
        stream.finish();
    }
}

