/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.ontology.Profile;
import org.apache.jena.ontology.impl.OWLDLProfile;
import org.apache.jena.ontology.impl.OWLLiteProfile;
import org.apache.jena.ontology.impl.OWLProfile;
import org.apache.jena.ontology.impl.RDFSProfile;
import org.apache.jena.vocabulary.OWL1;
import org.apache.jena.vocabulary.RDFS;

public class ProfileRegistry {
    public static final String OWL_LANG = OWL1.FULL_LANG.getURI();
    public static final String OWL_DL_LANG = OWL1.DL_LANG.getURI();
    public static final String OWL_LITE_LANG = OWL1.LITE_LANG.getURI();
    public static final String RDFS_LANG = RDFS.getURI();
    private static Object[][] s_initData = new Object[][]{{OWL_LANG, new OWLProfile()}, {OWL_DL_LANG, new OWLDLProfile()}, {OWL_LITE_LANG, new OWLLiteProfile()}, {RDFS_LANG, new RDFSProfile()}};
    private static ProfileRegistry s_instance = new ProfileRegistry();
    private Map<String, Profile> m_registry = new HashMap<String, Profile>();

    private ProfileRegistry() {
        for (Object[] aS_initData : s_initData) {
            this.registerProfile((String)aS_initData[0], (Profile)aS_initData[1]);
        }
    }

    public static ProfileRegistry getInstance() {
        return s_instance;
    }

    public void registerProfile(String uri, Profile profile) {
        this.m_registry.put(uri, profile);
    }

    public Profile getProfile(String uri) {
        return this.m_registry.get(uri);
    }
}

