/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.modelmutator.mutation;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.emfstore.modelmutator.ESModelMutatorUtil;
import org.eclipse.emf.emfstore.modelmutator.ESMutationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutationTargetSelector {
    private final ESModelMutatorUtil util;
    private final Collection<EClass> excludedEClasses = new HashSet<EClass>();
    private final Collection<EStructuralFeature> excludedFeatures = new HashSet<EStructuralFeature>();
    private final Collection<EObject> excludedObjects = new HashSet<EObject>();
    private final Set<Predicate<? super EStructuralFeature>> targetFeaturePredicates = new HashSet<Predicate<? super EStructuralFeature>>();
    private final Set<Predicate<? super EObject>> targetObjectPredicates = new HashSet<Predicate<? super EObject>>();
    private final Set<Predicate<? super Object>> originalFeatureValuePredicates = new HashSet<Predicate<? super Object>>();
    private EObject targetObject;
    private EStructuralFeature targetFeature;

    public MutationTargetSelector(ESModelMutatorUtil util) {
        this.util = util;
        this.addExcludedEStructuralFeaturesAndEClassesFromConfig();
    }

    private void addExcludedEStructuralFeaturesAndEClassesFromConfig() {
        this.excludedFeatures.addAll(this.util.getModelMutatorConfiguration().geteStructuralFeaturesToIgnore());
        this.excludedEClasses.addAll(this.util.getModelMutatorConfiguration().geteClassesToIgnore());
    }

    public MutationTargetSelector(ESModelMutatorUtil util, MutationTargetSelector selector) {
        this.util = util;
        this.setupFromOtherSelector(selector);
    }

    private void setupFromOtherSelector(MutationTargetSelector selector) {
        this.setupExcludedEClasses(selector);
        this.setupExcludedObjects(selector);
        this.setupExcludedFeatures(selector);
        this.setTargetObject(selector.getTargetObject());
        this.setTargetFeature(selector.getTargetFeature());
        this.targetFeaturePredicates.addAll(selector.getTargetFeaturePredicates());
        this.targetObjectPredicates.addAll(selector.getTargetObjectPredicates());
        this.originalFeatureValuePredicates.addAll(selector.getOriginalFeatureValuePredicates());
    }

    private void setupExcludedEClasses(MutationTargetSelector selector) {
        this.getExcludedEClasses().clear();
        this.getExcludedEClasses().addAll(selector.getExcludedEClasses());
    }

    private void setupExcludedObjects(MutationTargetSelector selector) {
        this.getExcludedObjects().clear();
        this.getExcludedObjects().addAll(selector.getExcludedObjects());
    }

    private void setupExcludedFeatures(MutationTargetSelector selector) {
        this.getExcludedFeatures().clear();
        this.getExcludedFeatures().addAll(selector.getExcludedFeatures());
    }

    protected Collection<EClass> getExcludedEClasses() {
        return this.excludedEClasses;
    }

    protected Collection<EStructuralFeature> getExcludedFeatures() {
        return this.excludedFeatures;
    }

    protected Collection<EObject> getExcludedObjects() {
        return this.excludedObjects;
    }

    protected EObject getTargetObject() {
        return this.targetObject;
    }

    protected void setTargetObject(EObject targetObject) {
        this.targetObject = targetObject;
    }

    protected EStructuralFeature getTargetFeature() {
        return this.targetFeature;
    }

    protected void setTargetFeature(EStructuralFeature targetFeature) {
        this.targetFeature = targetFeature;
    }

    protected Set<Predicate<? super EStructuralFeature>> getTargetFeaturePredicates() {
        return this.targetFeaturePredicates;
    }

    private Predicate<? super EStructuralFeature> getTargetFeaturePredicatesConjunction() {
        return Predicates.and(this.getTargetFeaturePredicates());
    }

    protected Set<Predicate<? super EObject>> getTargetObjectPredicates() {
        return this.targetObjectPredicates;
    }

    private Predicate<? super EObject> getTargetObjectPredicatesConjunction() {
        return Predicates.and(this.getTargetObjectPredicates());
    }

    protected Set<Predicate<? super Object>> getOriginalFeatureValuePredicates() {
        return this.originalFeatureValuePredicates;
    }

    private Predicate<? super Object> getOriginalFeatureValuePredicatesConjunction() {
        return Predicates.and(this.getOriginalFeatureValuePredicates());
    }

    protected void doSelection() throws ESMutationException {
        List<EStructuralFeature> features = this.getShuffledFeaturesToSelect();
        for (EStructuralFeature feature : features) {
            for (EObject eObject : this.getShuffledTargetObjectsToSelect(feature)) {
                if (!this.isValid(feature, eObject)) continue;
                this.setTargetFeature(feature);
                this.setTargetObject(eObject);
                return;
            }
        }
        throw new ESMutationException("No valid target found.");
    }

    private List<EStructuralFeature> getShuffledFeaturesToSelect() {
        if (this.hasTargetFeature()) {
            return Lists.newArrayList((Object[])new EStructuralFeature[]{this.getTargetFeature()});
        }
        if (this.hasTargetObject()) {
            return this.getShuffledAvailableFeaturesFromTargetObject();
        }
        return this.getShuffledAvailableFeatures();
    }

    private boolean hasTargetFeature() {
        return this.targetFeature != null;
    }

    private boolean hasTargetObject() {
        return this.targetObject != null;
    }

    private List<EStructuralFeature> getShuffledAvailableFeaturesFromTargetObject() {
        ArrayList<EStructuralFeature> availableFeatures = new ArrayList<EStructuralFeature>();
        EClass eClassOfTargetObject = this.targetObject.eClass();
        availableFeatures.addAll((Collection<EStructuralFeature>)eClassOfTargetObject.getEAllStructuralFeatures());
        this.excludeAndShuffleTargetFeatures(availableFeatures);
        return availableFeatures;
    }

    private void excludeAndShuffleTargetFeatures(List<EStructuralFeature> features) {
        features.removeAll(this.excludedFeatures);
        this.filterTargetFeaturePredicates(features);
        Collections.shuffle(features, this.getRandom());
    }

    private void filterTargetFeaturePredicates(List<EStructuralFeature> features) {
        for (EStructuralFeature feature : Lists.newArrayList(features)) {
            if (this.getTargetFeaturePredicatesConjunction().apply((Object)feature)) continue;
            features.remove(feature);
        }
    }

    private List<EStructuralFeature> getShuffledAvailableFeatures() {
        List<EStructuralFeature> features = this.getAvailableFeatures();
        this.excludeAndShuffleTargetFeatures(features);
        return features;
    }

    private List<EStructuralFeature> getAvailableFeatures() {
        return Lists.newArrayList(this.util.getAvailableFeatures(this.getTargetFeaturePredicatesConjunction()));
    }

    private List<EObject> getShuffledTargetObjectsToSelect(EStructuralFeature feature) {
        if (this.hasTargetObject()) {
            return Lists.newArrayList((Object[])new EObject[]{this.targetObject});
        }
        return this.getShuffledEObjectsForAvailableFeature(feature);
    }

    private List<EObject> getShuffledEObjectsForAvailableFeature(EStructuralFeature feature) {
        ArrayList<EObject> eObjects = this.getEObjectsForAvailableFeature(feature);
        this.excludeAndShuffleTargetObjects(eObjects);
        return eObjects;
    }

    private void excludeAndShuffleTargetObjects(List<EObject> eObjects) {
        eObjects.removeAll(this.excludedObjects);
        this.filterTargetObjectPredicates(eObjects);
        Collections.shuffle(eObjects);
    }

    private void filterTargetObjectPredicates(List<EObject> eObjects) {
        for (EObject eObject : Lists.newArrayList(eObjects)) {
            if (this.getTargetObjectPredicatesConjunction().apply((Object)eObject)) continue;
            eObjects.remove(eObject);
        }
    }

    private ArrayList<EObject> getEObjectsForAvailableFeature(EStructuralFeature feature) {
        Predicate<? super EObject> targetObjectPredicate = this.getTargetObjectPredicatesConjunction();
        return Lists.newArrayList(this.util.getOfferingEObjectsForAvailableFeature(feature, targetObjectPredicate));
    }

    private Random getRandom() {
        return this.util.getModelMutatorConfiguration().getRandom();
    }

    protected boolean isValid() {
        return this.isValid(this.targetFeature, this.targetObject);
    }

    private boolean isValid(EStructuralFeature feature, EObject eObject) {
        if (feature == null || eObject == null) {
            return false;
        }
        EClass eClass = eObject.eClass();
        EList featuresOfEClass = eClass.getEAllStructuralFeatures();
        return !this.isExcluded(feature, eObject) && featuresOfEClass.contains((Object)feature) && this.fulfillsTargetFeaturePredicate(feature) && this.fulfillsTargetObjectPredicate(eObject) && this.fulfullsOriginalFeatureValuePredicate(feature, eObject);
    }

    private boolean isExcluded(EStructuralFeature feature, EObject eObject) {
        EClass eClass = eObject.eClass();
        return this.excludedFeatures.contains(feature) || this.excludedEClasses.contains(feature.getEType()) || this.excludedEClasses.contains(eClass) || this.excludedObjects.contains(eObject);
    }

    private boolean fulfillsTargetFeaturePredicate(EStructuralFeature feature) {
        return this.getTargetFeaturePredicatesConjunction().apply((Object)feature);
    }

    private boolean fulfillsTargetObjectPredicate(EObject eObject) {
        return this.getTargetObjectPredicatesConjunction().apply((Object)eObject);
    }

    private boolean fulfullsOriginalFeatureValuePredicate(EStructuralFeature feature, EObject eObject) {
        Object originalValue = eObject.eGet(feature);
        return this.getOriginalFeatureValuePredicatesConjunction().apply(originalValue);
    }

    protected Object selectRandomValueFromTargetObject() {
        return this.selectRandomContainedValue((Predicate<? super Object>)Predicates.alwaysTrue());
    }

    protected Object selectRandomContainedValue(Predicate<? super Object> predicate) {
        if (!this.isValid()) {
            throw new IllegalStateException("There is no valid selection to get value for.");
        }
        if (this.getTargetFeature().isMany()) {
            return this.selectRandomValueFromTargetObjectWithMultiValuedFeature(predicate);
        }
        return this.selectRandomValueFromTargetObjectWithSingleValuedFeature(predicate);
    }

    private Object selectRandomValueFromTargetObjectWithMultiValuedFeature(Predicate<? super Object> predicate) {
        List values = (List)this.getTargetValue();
        Iterable filteredValues = Iterables.filter((Iterable)values, predicate);
        int randomIndex = this.getRandomIndexFromValueRange(filteredValues);
        Object randomObject = Iterables.get((Iterable)filteredValues, (int)randomIndex);
        return randomObject;
    }

    private Object getTargetValue() {
        return this.getTargetObject().eGet(this.getTargetFeature());
    }

    private Object selectRandomValueFromTargetObjectWithSingleValuedFeature(Predicate<? super Object> predicate) {
        Object targetValue = this.getTargetValue();
        if (predicate.apply(targetValue)) {
            return targetValue;
        }
        return null;
    }

    protected int getRandomIndexFromTargetObjectAndFeatureValueRange() {
        Collection values = (Collection)this.getTargetValue();
        return this.getRandomIndexFromValueRange(values);
    }

    private int getRandomIndexFromValueRange(Iterable<Object> values) {
        int numberOfCurrentValues = Iterables.size(values);
        int randomIndex = numberOfCurrentValues > 0 ? this.getRandom().nextInt(numberOfCurrentValues) : 0;
        return randomIndex;
    }
}

