/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfatic.ui.hyperlinks;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfatic.core.lang.gen.ast.Attribute;
import org.eclipse.emf.emfatic.core.lang.gen.ast.ClassDecl;
import org.eclipse.emf.emfatic.core.lang.gen.ast.DataTypeDecl;
import org.eclipse.emf.emfatic.core.lang.gen.ast.EmfaticASTNode;
import org.eclipse.emf.emfatic.core.lang.gen.ast.EnumDecl;
import org.eclipse.emf.emfatic.core.lang.gen.ast.Operation;
import org.eclipse.emf.emfatic.core.lang.gen.ast.Reference;
import org.eclipse.emf.emfatic.core.lang.gen.ast.TypeParam;
import org.eclipse.emf.emfatic.ui.editor.EmfaticEditor;
import org.eclipse.emf.emfatic.ui.hyperlinks.EmfaticHyperlink;
import org.eclipse.gymnast.runtime.core.ast.ASTNode;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;

public class EmfaticHyperlinkDetector
implements IHyperlinkDetector {
    private EmfaticEditor _editor;

    public EmfaticHyperlinkDetector(EmfaticEditor editor) {
        this._editor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null) {
            return null;
        }
        EmfaticEditor.ReferedEcoreDecl red = this._editor.getReferedEcoreDecl(region.getOffset(), region.getLength());
        if (red == null || red.node == null || red.ecoreDecl == null) {
            return null;
        }
        EObject ecoreDecl = red.ecoreDecl;
        EmfaticASTNode node = red.node;
        EmfaticASTNode landingPlace = EmfaticHyperlinkDetector.getLandingPlace(ecoreDecl, this._editor);
        if (landingPlace == null) {
            return null;
        }
        Region underlineRegion = new Region(node.getRangeStart(), node.getRangeLength());
        return new IHyperlink[]{new EmfaticHyperlink(this._editor, (IRegion)underlineRegion, landingPlace)};
    }

    public static EmfaticASTNode getLandingPlace(EObject ecoreDecl, EmfaticEditor editor) {
        ASTNode cstDecl = (ASTNode)editor.getCstDecl2EcoreAST().getInv((Object)ecoreDecl);
        if (cstDecl == null || !(cstDecl instanceof EmfaticASTNode)) {
            return null;
        }
        EmfaticASTNode landingPlace = (EmfaticASTNode)cstDecl;
        if (cstDecl instanceof ClassDecl) {
            landingPlace = ((ClassDecl)cstDecl).getName();
        }
        if (cstDecl instanceof DataTypeDecl) {
            landingPlace = ((DataTypeDecl)cstDecl).getName();
        }
        if (cstDecl instanceof EnumDecl) {
            landingPlace = ((EnumDecl)cstDecl).getName();
        }
        if (cstDecl instanceof TypeParam) {
            landingPlace = ((TypeParam)cstDecl).getTypeVarName();
        }
        if (cstDecl instanceof Reference) {
            landingPlace = ((Reference)cstDecl).getName();
        }
        if (cstDecl instanceof Attribute) {
            landingPlace = ((Attribute)cstDecl).getName();
        }
        if (cstDecl instanceof Operation) {
            landingPlace = ((Operation)cstDecl).getName();
        }
        return landingPlace;
    }
}

