/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfatic.ui.templates;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.emf.emfatic.ui.EmfaticUIPlugin;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;

public class EmfaticTemplateCompletionProcessor
extends TemplateCompletionProcessor {
    TemplateContextType context;

    public EmfaticTemplateCompletionProcessor(String contextName) {
        this.context = EmfaticUIPlugin.getDefault().getEmfaticContextTypeRegistry().getContextType(contextName);
    }

    protected Template[] getTemplates(String contextTypeId) {
        return EmfaticUIPlugin.getDefault().getEmfaticTemplateStore().getTemplates();
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return this.context;
    }

    protected Image getImage(Template template) {
        return EmfaticUIPlugin.getImage("template");
    }

    public ArrayList<ICompletionProposal> addTemplateProposals(ITextViewer viewer, int documentOffset, String prefix) {
        ArrayList<ICompletionProposal> propList = new ArrayList<ICompletionProposal>();
        ICompletionProposal[] templateProposals = this.computeCompletionProposals(viewer, documentOffset);
        int j = 0;
        while (j < templateProposals.length) {
            ICompletionProposal proposal = templateProposals[j];
            if (proposal.getDisplayString().startsWith(prefix)) {
                propList.add(templateProposals[j]);
            }
            ++j;
        }
        Collections.sort(propList, new CompletionProposalComparator());
        return propList;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'@'};
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            if (viewer.getDocument().getChar(offset - 1) == '@') {
                ICompletionProposal[] res = super.computeCompletionProposals(viewer, offset);
                return res;
            }
        }
        catch (BadLocationException badLocationException) {}
        return new ICompletionProposal[0];
    }
}

