package pam.simulation;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.refactoring.core.Refactoring;
import org.eclipse.emf.refactor.refactoring.runtime.ltk.LtkEmfRefactoringProcessorAdapter;
import org.eclipse.emf.refactor.smells.configuration.managers.ConfigurationManager;
import org.eclipse.emf.refactor.smells.core.MetricBasedModelSmellFinderClass;
import org.eclipse.emf.refactor.smells.core.ModelSmell;
import org.eclipse.emf.refactor.smells.eraser.managers.EraseManager;
import org.eclipse.emf.refactor.smells.runtime.core.ModelSmellFinder;
import org.eclipse.emf.refactor.smells.runtime.core.Result;
import org.eclipse.jface.dialogs.MessageDialog;

public class Simulator {
	
	private static LinkedList<Result> results = new LinkedList<Result>();
	private static Set<Refactoring> fixingRefactorings = new HashSet<Refactoring>();
	
	public static void simulate(IProject project, EObject root) {
		results = searchSmells(project, root);
		boolean executed = false;
		if (! results.isEmpty()) {
			for (Result result: results) {
				for (LinkedList<EObject> smellOccurrence : result.getModelelements()) {
					fixingRefactorings = EraseManager.getInstance().getFixingRefactorings(result.getSmell());
					System.out.println("Number of fixing refactorings: " + fixingRefactorings.size());
					Refactoring refactoring = null;
					if (! fixingRefactorings.isEmpty()) {
						refactoring = fixingRefactorings.iterator().next();
						refactoring.getController().setSelection(smellOccurrence);
						refactoring.getController().getDataManagementObject().preselect(smellOccurrence);
						((ISimulationController) refactoring.getController()).setParameters();
						LtkEmfRefactoringProcessorAdapter processor = (LtkEmfRefactoringProcessorAdapter) 
									refactoring.getController().getLtkRefactoringProcessor();
						if (processor.checkConditions()) {
							try {
								processor.createChange(new NullProgressMonitor()).perform(new NullProgressMonitor());
								executed = true;
							} catch (OperationCanceledException e) {
								MessageDialog.openError(null, "PAM Simulation", e.getMessage());
								e.printStackTrace();
							} 
							catch (CoreException e) {
								MessageDialog.openError(null, "PAM Simulation", e.getMessage());
								e.printStackTrace();
							}
						}
					}
					if (executed) {
						break;
					}
				}	
				if (executed) {
					break;
				}
			}
			if (executed) {
				simulate(project, root);
			}
		}		
	}

	private static LinkedList<Result> searchSmells(IProject project, EObject root) {
		LinkedList<Result> results = new LinkedList<Result>();
		ConfigurationManager.getInstance();
		LinkedList<ModelSmell> smells = ConfigurationManager.getSelectedModelSmells(project);
		for(ModelSmell smell : smells){
			if(smell.getFinderClass() instanceof MetricBasedModelSmellFinderClass)
				((MetricBasedModelSmellFinderClass)smell.getFinderClass()).setLimit(ConfigurationManager.getLimit(project, smell.getId()));
		}
		LinkedList<Result> resultsTmp = ModelSmellFinder.findModelSmells(smells, root);
		for (Result result: resultsTmp) {
			if (! result.getModelelements().isEmpty()) {
				results.add(result);
			}
		}
		return results;
	}

	public static void optimize(IProject project, EObject root) {
		System.out.println("===>>> optimize start");
		results = searchSmells(project, root);
		for (Result result: results) {
			System.out.println("=======================");
			System.out.println("Result: " + result.getSmell().getName());
			System.out.println("Number of smell occurences: " + result.getModelelements().size());
			for (LinkedList<EObject> smellOccurrence : result.getModelelements()) {
				fixingRefactorings = EraseManager.getInstance().getFixingRefactorings(result.getSmell());
				System.out.println("Number of fixing refactorings: " + fixingRefactorings.size());
				Refactoring refactoring = null;
				if (! fixingRefactorings.isEmpty()) {
					refactoring = fixingRefactorings.iterator().next();
					if (refactoring.getGui().showInMenu(smellOccurrence)) {
						System.out.println("Context: " + smellOccurrence.get(0));
						System.out.println("Refactoring: " + refactoring.getName());
						refactoring.getController().setSelection(smellOccurrence);
						refactoring.getController().getDataManagementObject().preselect(smellOccurrence);
						((ISimulationController) refactoring.getController()).setParameters();
						LtkEmfRefactoringProcessorAdapter processor = (LtkEmfRefactoringProcessorAdapter) 
								refactoring.getController().getLtkRefactoringProcessor();
						System.out.println("CheckConditions: " + processor.checkConditions());
						if (processor.checkConditions()) {
							Logger.logRefactoring(refactoring, root);
						}
						System.out.println("----------------------");
					}
				}
			}
		}
		System.out.println("===>>> optimize stop");
	}
}
