/**
 * <copyright>
 * </copyright>
 *
 * $Id: RefactoringControllerHenshin.javajet,v 1.2 2012/11/26 15:39:38 tarendt Exp $
 */
package pam.refactorings.pam.upssplit.opt;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.refactoring.core.Refactoring;
import org.eclipse.emf.refactor.refactoring.henshin.interfaces.IHenshinController;
import org.eclipse.emf.refactor.refactoring.henshin.interfaces.IHenshinDataManagement;
import org.eclipse.emf.refactor.refactoring.henshin.managers.HenshinRuntimeManager;
import org.eclipse.emf.refactor.refactoring.henshin.runtime.HenshinLtkEmfRefactoringProcessorAdapter;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;

import pam.refactorings.Logger;
import pam.refactorings.Optimizer;
import pam.refactorings.UninterruptiblePowerSupplyPair;
import pam.simulation.ISimulationController;
import PAM.UninterruptiblePowerSupply;

/**
 * Concrete EMF model refactoring class implementing IHenshinController. 
 * @generated
 */
public final class RefactoringController implements ISimulationController, IHenshinController{

	private List<UninterruptiblePowerSupplyPair> upspairs;
	
	/**
	 * Refactoring supported by the controller.
	 * @generated
	 */
	private Refactoring parent;
	
	/**
	 * DataManagement object of the model refactoring.
	 * @generated
	 */
	private RefactoringDataManagement dataManagement = 
									new RefactoringDataManagement();
									
	/**
	 * Invocation context of the model refactoring.
	 * @generated
	 */								
	private List<EObject> selection = new ArrayList<EObject>();
	
	/**
	 * HenshinRuntimeManager that executes Henshin transformations using 
	 * the Henshin interpreter.
	 * @generated
	 */
	private HenshinRuntimeManager henshinRuntimeManager = 
		new HenshinRuntimeManager(new ArrayList<EObject>(0), dataManagement);
	
	/**
	 * Ltk RefactoringProcessor of the model refactoring.
	 * @generated
	 */
	private InternalRefactoringProcessor refactoringProcessor = null;
	
	/**
	 * Gets the Refactoring supported by the controller.
	 * @return Refactoring supported by the controller.
	 * @see org.eclipse.emf.refactor.refactoring.interfaces.IController#getParent()
	 * @generated
	 */
	@Override
	public Refactoring getParent() {
		return this.parent;
	}
	
	/**
	 * Sets the Refactoring supported by the controller.
	 * @param refactoring Refactoring supported by the controller.
	 * @see org.eclipse.emf.refactor.refactoring.interfaces.IController#
	 * setParent(org.eclipse.emf.refactor.refactoring.core.Refactoring)
	 * @generated
	 */
	@Override
	public void setParent(Refactoring refactoring) {
		this.parent = refactoring;
	}
	
	/**
	 * Returns the DataManagement object of the model refactoring.
	 * @return DataManagement object of the model refactoring.
	 * @see org.eclipse.emf.refactor.refactoring.henshin.interfaces.IHenshinController#
	 * getDataManagementObject()
	 * @generated
	 */
	@Override
	public IHenshinDataManagement getDataManagementObject() {
		return this.dataManagement;
	}
	
	/**
	 * Gets a HenshinRuntimeManager that executes Henshin transformations using 
	 * the Henshin interpreter.
	 * @return HenshinRuntimeManager that executes Henshin transformations using 
	 * the Henshin interpreter.
	 * @see org.eclipse.emf.refactor.refactoring.henshin.interfaces.IHenshinController#
	 * getHenshinRuntimeManager()
	 * @generated
	 */
	@Override
	public HenshinRuntimeManager getHenshinRuntimeManager() {
		return this.henshinRuntimeManager;
	}

	/**
	 * Returns the ltk RefactoringProcessor of the model refactoring.
	 * @return Ltk RefactoringProcessor of the model refactoring.
	 * @see org.eclipse.emf.refactor.refactoring.interfaces.IController#
	 * getLtkRefactoringProcessor()
	 * @generated
	 */
	@Override
	public RefactoringProcessor getLtkRefactoringProcessor() {
		return this.refactoringProcessor;
	}
	
	/**
	 * Sets the selected EObject (invocation context of the model refactoring).
	 * @param selection Invocation context of the model refactoring.
	 * @see org.eclipse.emf.refactor.refactoring.interfaces.IController#
	 * setSelection(java.util.List)
	 * @generated
	 */
	@Override
	public void setSelection(List<EObject> selection) {
		this.selection = selection;
		this.henshinRuntimeManager = new HenshinRuntimeManager(this.selection, this.dataManagement);
		this.refactoringProcessor = 
				new InternalRefactoringProcessor(this.selection);
	}	
	
	/**
	 * Returns a Runnable object that executes the model refactoring.
	 * @return Runnable object that executes the model refactoring.
	 * @generated
	 */
	private Runnable applyRefactoring() {
		return new Runnable() {				
			/**
			 * @see java.lang.Runnable#run()
			 * @generated
			 */
			@Override
			public void run() {
				Logger.logRefactoring(parent, selection.get(0));
				henshinRuntimeManager = new HenshinRuntimeManager(selection, dataManagement);
				henshinRuntimeManager.run();
			}
		};
	}

	/**
	 * Internal class for providing an instance of a LTK RefactoringProcessor 
	 * used for EMF model refactorings using Henshin transformations.	 
	 * @generated
	 */
	public final class InternalRefactoringProcessor extends 
									HenshinLtkEmfRefactoringProcessorAdapter {

		/**
		 * Constructor using the invocation context of the model refactoring.
		 * @param selection Invocation context of the model refactoring.
		 * @generated
		 */
		private InternalRefactoringProcessor(List<EObject> selection){
				super(getParent(), selection, applyRefactoring());				
		}
		
		@Override
		public RefactoringStatus checkInitialConditions() {
			RefactoringStatus result = new RefactoringStatus();
			upspairs = Optimizer.getOptimalUPSPairs((UninterruptiblePowerSupply) selection.get(0));
			if (upspairs.isEmpty()) {
				result.addFatalError("There is no power supply available for optimizing your system!");
			}
			return result;
		}
		
	}

	public List<UninterruptiblePowerSupplyPair> getUninterruptiblePowerSupplyPairs() {
		upspairs = Optimizer.getOptimalUPSPairs((UninterruptiblePowerSupply) selection.get(0));
		return upspairs;
	}

	@SuppressWarnings("unchecked")
	@Override
	public void setParameters() {
		UninterruptiblePowerSupplyPair upspair = getUninterruptiblePowerSupplyPairs().get(0);
		dataManagement.getInPortByName("ups1").setValue(upspair.getUps1());
		dataManagement.getInPortByName("ups2").setValue(upspair.getUps2());
	}

}