/**
 * <copyright>
 * </copyright>
 *
 * $Id: RefactoringWizardPageHenshin.javajet,v 1.2 2012/11/26 15:39:38 tarendt Exp $
 */
 package pam.refactorings.pam.upsmerge;

import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

import pam.refactorings.UninterruptiblePowerSupplyPair;
import PAM.UninterruptiblePowerSupply;

/**
 * Class for setting model refactoring specific parameters
 * by the user.
 * @generated
 */
public class RefactoringWizardPage extends 
				UserInputWizardPage implements Listener {
				
	/**
	 * Controller of the EMF model refactoring.
	 * @generated
	 */			
	private final RefactoringController controller;
	
	/**
	 * Label for each parameter.
	 * @generated
	 */
	private Label upsPairLabel;
	
	private Combo upsPairWidget;
	
	private Label upsLabel;
	
	private Combo upsWidget;

	/**
	 * Default constructor using a name and the controller of the 
	 * EMF model refactoring.
	 * @param name Name of the WizardPage.
	 * @param controller Controller of the EMF model refactoring.
	 * @generated
	 */
	public RefactoringWizardPage
		(String name, RefactoringController controller) {
		super(name);
		this.controller = controller;
	}

	/**
	 * @see org.eclipse.swt.widgets.Listener#
	 * handleEvent(org.eclipse.swt.widgets.Event)
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void handleEvent(Event event) {		
		getWizard().getContainer().updateButtons();
				
		if (event.widget == upsPairWidget) {
			int index = upsPairWidget.getSelectionIndex();
			UninterruptiblePowerSupplyPair upsPair = controller.getUninterruptiblePowerSupplyPairs().get(index);
			((RefactoringDataManagement) this.controller.getDataManagementObject()).
						getInPortByName("selectedEObject").setValue(upsPair.getUps1());
			((RefactoringDataManagement) this.controller.getDataManagementObject()).
						getInPortByName("ups2").setValue(upsPair.getUps2());
			upsPairWidget.setEnabled(false);
			controller.setUninterruptiblePowerSupplies(upsPair);
			upsWidget.clearSelection();
			for (int i = 0; i < controller.getUninterruptiblePowerSupplies().size(); i++) {
				upsWidget.add(controller.getUninterruptiblePowerSupplies().get(i).getName());
		    }
			upsWidget.setEnabled(true);
		}
		
		if (event.widget == upsWidget) {
			int index = upsWidget.getSelectionIndex();
			UninterruptiblePowerSupply ups = controller.getUninterruptiblePowerSupplies().get(index);
			((RefactoringDataManagement) this.controller.getDataManagementObject()).
						getInPortByName("ups").setValue(ups);
		}
	}
	
	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#
	 * createControl(org.eclipse.swt.widgets.Composite)
	 * @generated
	 */
	@Override
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout gl = new GridLayout();
		gl.numColumns = 2;
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		composite.setLayout(gl);			
		
		upsPairLabel = new Label(composite, SWT.NONE);
		upsPairLabel.setText("Power Supplies to be merged: ");
		upsPairLabel.setEnabled(true);
		
		upsPairWidget = new Combo(composite, SWT.DROP_DOWN | SWT.BORDER);	
		upsPairWidget.setToolTipText("Power Supples to be merged");
		upsPairWidget.setEnabled(true);
		upsPairWidget.setLayoutData(gd);
		upsPairWidget.addListener(SWT.Modify, this);
		
		for (int i = 0; i < controller.getUninterruptiblePowerSupplyPairs().size(); i++) {
			upsPairWidget.add(controller.getUninterruptiblePowerSupplyPairs().get(i).toString());
	    }	
		
		upsLabel = new Label(composite, SWT.NONE);
		upsLabel.setText("Power Supply to be used instead: ");
		upsLabel.setEnabled(true);
		
		upsWidget = new Combo(composite, SWT.DROP_DOWN | SWT.BORDER);	
		upsWidget.setToolTipText("Power Supply to be used instead");
		upsWidget.setEnabled(false);
		upsWidget.setLayoutData(gd);
		upsWidget.addListener(SWT.Modify, this);
		
		setControl(composite);
	}
	
}
	