/**
 * <copyright>
 * </copyright>
 *
 * $Id: RefactoringWizardPageHenshin.javajet,v 1.2 2012/11/26 15:39:38 tarendt Exp $
 */
 package pam.refactorings.pam.substituteupswithoutcontext.opt;

import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

import PAM.UninterruptiblePowerSupply;

/**
 * Class for setting model refactoring specific parameters
 * by the user.
 * @generated
 */
public class RefactoringWizardPage extends 
				UserInputWizardPage implements Listener {
				
	/**
	 * Controller of the EMF model refactoring.
	 * @generated
	 */			
	private final RefactoringController controller;
	
	/**
	 * Label for each parameter.
	 * @generated
	 */
	private Label upsLabel;
	
	private Combo upsWidget;

	/**
	 * Default constructor using a name and the controller of the 
	 * EMF model refactoring.
	 * @param name Name of the WizardPage.
	 * @param controller Controller of the EMF model refactoring.
	 * @generated
	 */
	public RefactoringWizardPage
		(String name, RefactoringController controller) {
		super(name);
		this.controller = controller;
	}

	/**
	 * @see org.eclipse.swt.widgets.Listener#
	 * handleEvent(org.eclipse.swt.widgets.Event)
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void handleEvent(Event event) {		
		getWizard().getContainer().updateButtons();
				
		if (upsWidget != null) {
			int index = upsWidget.getSelectionIndex();
			UninterruptiblePowerSupply ups = controller.getUninterruptiblePowerSupplies().get(index);
			if (ups != null) {
				((RefactoringDataManagement) 
						this.controller.getDataManagementObject()).
						getInPortByName("ups").
						setValue(ups);
			} else {
				((RefactoringDataManagement) 
						this.controller.getDataManagementObject()).
						getInPortByName("ups").
						setValue("unspecified");
			}
		}

	}
	
	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#
	 * createControl(org.eclipse.swt.widgets.Composite)
	 * @generated
	 */
	@Override
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout gl = new GridLayout();
		gl.numColumns = 2;
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		composite.setLayout(gl);
			
		
		upsLabel = new Label(composite, SWT.NONE);
		upsLabel.setText("Power supply to be substituted with: ");
		upsLabel.setEnabled(true);
		
		upsWidget = new Combo(composite, SWT.DROP_DOWN | SWT.BORDER);	
		upsWidget.setToolTipText("Power supply to be substituted with");
		upsWidget.setEnabled(true);
		upsWidget.setLayoutData(gd);
		upsWidget.addListener(SWT.Modify, this);
		
		for (int i = 0; i < controller.getUninterruptiblePowerSupplies().size(); i++) {
			upsWidget.add(controller.getUninterruptiblePowerSupplies().get(i).getName());
	    }	
		
		setControl(composite);
	}
	
}
	