/**
 * <copyright>
 * </copyright>
 *
 * $Id: RefactoringWizardPageHenshin.javajet,v 1.2 2012/11/26 15:39:38 tarendt Exp $
 */
 package pam.refactorings.pam.substituteservernode;

import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

import PAM.ServerNode;

/**
 * Class for setting model refactoring specific parameters
 * by the user.
 * @generated
 */
public class RefactoringWizardPage extends 
				UserInputWizardPage implements Listener {
				
	/**
	 * Controller of the EMF model refactoring.
	 * @generated
	 */			
	private final RefactoringController controller;
	
	/**
	 * Label for each parameter.
	 * @generated
	 */
	private Label serverLabel;
	
	private Combo serverWidget;

	/**
	 * Default constructor using a name and the controller of the 
	 * EMF model refactoring.
	 * @param name Name of the WizardPage.
	 * @param controller Controller of the EMF model refactoring.
	 * @generated
	 */
	public RefactoringWizardPage
		(String name, RefactoringController controller) {
		super(name);
		this.controller = controller;
	}

	/**
	 * @see org.eclipse.swt.widgets.Listener#
	 * handleEvent(org.eclipse.swt.widgets.Event)
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void handleEvent(Event event) {		
		getWizard().getContainer().updateButtons();
				
		if (serverWidget != null) {
			int index = serverWidget.getSelectionIndex();
			ServerNode server = controller.getServerNodes().get(index);
			if (server != null) {
				((RefactoringDataManagement) 
						this.controller.getDataManagementObject()).
						getInPortByName("server").
						setValue(server);
			} else {
				((RefactoringDataManagement) 
						this.controller.getDataManagementObject()).
						getInPortByName("server").
						setValue("unspecified");
			}
		}

	}
	
	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#
	 * createControl(org.eclipse.swt.widgets.Composite)
	 * @generated
	 */
	@Override
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout gl = new GridLayout();
		gl.numColumns = 2;
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		composite.setLayout(gl);
			
		
		serverLabel = new Label(composite, SWT.NONE);
		serverLabel.setText("Server node to be substituted with: ");
		serverLabel.setEnabled(true);
		
		serverWidget = new Combo(composite, SWT.DROP_DOWN | SWT.BORDER);	
		serverWidget.setToolTipText("Server node to be substituted with");
		serverWidget.setEnabled(true);
		serverWidget.setLayoutData(gd);
		serverWidget.addListener(SWT.Modify, this);
		
		for (int i = 0; i < controller.getServerNodes().size(); i++) {
			serverWidget.add(controller.getServerNodes().get(i).getName());
	    }	
		
		setControl(composite);
	}
	
}
	