/**
 * <copyright>
 * </copyright>
 *
 * $Id: RefactoringWizardPage.javajet,v 1.2 2012/10/16 21:03:02 tarendt Exp $
 */
 package pam.refactorings.pam.networksplit.opt;

import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

import pam.refactorings.NetworkNodePair;

/**
 * Class for setting model refactoring specific parameters
 * by the user.
 * @generated
 */
public class RefactoringWizardPage extends 
				UserInputWizardPage implements Listener {
	
	/**
	 * Controller of the EMF model refactoring.
	 * @generated
	 */			
	private final RefactoringController controller;
	
	/**
	 * Label for each parameter.
	 * @generated
	 */	
	private Label networkNodesLabel;
	
	/**
	 * TextField for each parameter.
	 * @generated
	 */
	private Combo networkNodesWidget;

	/**
	 * Default constructor using a name and the controller of the 
	 * EMF model refactoring.
	 * @param name Name of the WizardPage.
	 * @param controller Controller of the EMF model refactoring.
	 * @generated
	 */
	public RefactoringWizardPage
		(String name, RefactoringController controller) {
		super(name);
		this.controller = controller;
	}

	/**
	 * @see org.eclipse.swt.widgets.Listener#
	 * handleEvent(org.eclipse.swt.widgets.Event)
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void handleEvent(Event event) {		
		getWizard().getContainer().updateButtons();
				
		if (networkNodesWidget != null) {
			int index = networkNodesWidget.getSelectionIndex();
			NetworkNodePair pair = controller.getNetworkNodePairs().get(index);
			if (pair != null) {
				((RefactoringDataManagement) 
						this.controller.getDataManagementObject()).
						getInPortByName("networkNodes").
						setValue(pair);
			} else {
				((RefactoringDataManagement) 
						this.controller.getDataManagementObject()).
						getInPortByName("networkNodes").
						setValue(null);
			}
		}

	}
	
	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#
	 * createControl(org.eclipse.swt.widgets.Composite)
	 * @generated
	 */
	@Override
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout gl = new GridLayout();
		gl.numColumns = 2;
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		composite.setLayout(gl);
			
		
		networkNodesLabel = new Label(composite, SWT.NONE);
		networkNodesLabel.setText("Optimal Network Nodes to be used instead: ");
		networkNodesLabel.setEnabled(true);
		
		networkNodesWidget = new Combo(composite, SWT.BORDER);
		networkNodesWidget.setToolTipText("Optimal Network Nodes to be used instead");
		networkNodesWidget.setEnabled(true);
		networkNodesWidget.setLayoutData(gd);
		networkNodesWidget.addListener(SWT.Modify, this);
		
		for (int i = 0; i < controller.getNetworkNodePairs().size(); i++) {
			networkNodesWidget.add(controller.getNetworkNodePairs().get(i).toString());
	    }		
		
		setControl(composite);
	}
	
}
	