/**
 * <copyright>
 * </copyright>
 *
 * $Id: RefactoringController.javajet,v 1.2 2012/10/16 21:03:02 tarendt Exp $
 */
package pam.refactorings.pam.networksplit.opt;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.refactoring.core.Refactoring;
import org.eclipse.emf.refactor.refactoring.interfaces.IController;
import org.eclipse.emf.refactor.refactoring.interfaces.IDataManagement;
import org.eclipse.emf.refactor.refactoring.runtime.ltk.LtkEmfRefactoringProcessorAdapter;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;

import pam.refactorings.Logger;
import pam.refactorings.NetworkNodePair;
import pam.refactorings.Optimizer;
import pam.simulation.ISimulationController;
import PAM.NetworkNode;
import PAM.NetworkObjectLink;
import PAM.PAMFactory;
import PAM.Room;

public final class RefactoringController implements ISimulationController, IController {
	
	private List<NetworkNodePair> networkNodePairs;

	/**
	 * Refactoring supported by the controller.
	 * @generated
	 */
	private Refactoring parent;
	
	/**
	 * DataManagement object of the model refactoring.
	 * @generated
	 */
	private RefactoringDataManagement dataManagement = 
									new RefactoringDataManagement();
	
	/**
	 * Invocation context of the model refactoring.
	 * @generated
	 */	
	private List<EObject> selection = new ArrayList<EObject>();
	
	/**
	 * Ltk RefactoringProcessor of the model refactoring.
	 * @generated
	 */
	private InternalRefactoringProcessor refactoringProcessor = null;
	
	/**
	 * Gets the Refactoring supported by the controller.
	 * @return Refactoring supported by the controller.
	 * @see org.eclipse.emf.refactor.refactoring.interfaces.IController#getParent()
	 * @generated
	 */
	@Override
	public Refactoring getParent() {
		return this.parent;
	}
	
	/**
	 * Sets the Refactoring supported by the controller.
	 * @param emfRefactoring Refactoring supported by the controller.
	 * @see org.eclipse.emf.refactor.refactoring.interfaces.IController#
	 * setParent(org.eclipse.emf.refactor.refactoring.core.Refactoring)
	 * @generated
	 */
	@Override
	public void setParent(Refactoring emfRefactoring) {
		this.parent = emfRefactoring;
	}
	
	/**
	 * Returns the DataManagement object of the model refactoring.
	 * @return DataManagement object of the model refactoring.
	 * @see org.eclipse.emf.refactor.refactoring.interfaces.IController#
	 * getDataManagementObject()
	 * @generated
	 */
	@Override
	public IDataManagement getDataManagementObject() {
		return this.dataManagement;
	}

	/**
	 * Returns the ltk RefactoringProcessor of the model refactoring.
	 * @return Ltk RefactoringProcessor of the model refactoring.
	 * @see org.eclipse.emf.refactor.refactoring.interfaces.IController#
	 * getLtkRefactoringProcessor()
	 * @generated
	 */
	@Override
	public RefactoringProcessor getLtkRefactoringProcessor() {
		return this.refactoringProcessor;
	}
	
	/**
	 * Sets the selected EObject (invocation context of the model refactoring).
	 * @param selection Invocation context of the model refactoring.
	 * @see org.eclipse.emf.refactor.refactoring.interfaces.IController#
	 * setSelection(java.util.List)
	 * @generated
	 */
	@Override
	public void setSelection(List<EObject> selection) {
		this.selection = selection;
		this.refactoringProcessor = 
				new InternalRefactoringProcessor(this.selection);
	}	
	
	/**
	 * Returns a Runnable object that executes the model refactoring.
	 * @return Runnable object that executes the model refactoring.
	 * @generated
	 */
	private Runnable applyRefactoring() {
		return new Runnable() {				
			/**
			 * @see java.lang.Runnable#run()
			 * @generated
			 */
			@SuppressWarnings("unchecked")
			@Override
			public void run() {
				Logger.logRefactoring(parent, selection.get(0));
				NetworkNode nwNode = 
					(NetworkNode) dataManagement.
							getInPortByName(dataManagement.SELECTEDEOBJECT).getValue();
				NetworkNodePair networkNodes =
					(NetworkNodePair) dataManagement.getInPortByName("networkNodes").getValue();
				// start custom code
				Room room = Optimizer.getOwningRoom(nwNode);
				PAMFactory factory = PAMFactory.eINSTANCE;
				// create first network node copy and insert it into the room
				NetworkNode newNetworkNode1 = createNetworkNodeCopy(factory, networkNodes.getNode1());
				room.getContains().add(newNetworkNode1);
				// create second network node copy and insert it into the room
				NetworkNode newNetworkNode2 = createNetworkNodeCopy(factory, networkNodes.getNode2());
				room.getContains().add(newNetworkNode2);
				// link both new network nodes
				NetworkObjectLink newLink = factory.createNetworkObjectLink();
				room.getLinks().add(newLink);
				newLink.setConnect0(newNetworkNode1);
				newLink.setConnect1(newNetworkNode2);
				// redirect links 
				int max1 = Optimizer.numberOfIncomingLinks(networkNodes.getNode1());
				int links1 = 1;
				ArrayList<NetworkObjectLink> incomingLinks = Optimizer.getIncomingLinks(nwNode);
				for (NetworkObjectLink link : incomingLinks) {
					if (links1 < max1) {
						if (link.getConnect0() == nwNode) {
							link.setConnect0(newNetworkNode1);
							links1++;
						}
						if (link.getConnect1() == nwNode) {
							link.setConnect1(newNetworkNode1);
							links1++;
						}
					} else {
						if (link.getConnect0() == nwNode) {
							link.setConnect0(newNetworkNode2);
						}
						if (link.getConnect1() == nwNode) {
							link.setConnect1(newNetworkNode2);
						}
					}
				}
				// remove selected network node
				room.getContains().remove(nwNode);
			}
		};
	}

	protected NetworkNode createNetworkNodeCopy(PAMFactory factory, NetworkNode node1) {
		NetworkNode node = factory.createNetworkNode();
		node.setName(node1.getName());
		node.setMax_Throughput(node1.getMax_Throughput());
		node.setMax_Watt(node1.getMax_Watt());
		return node;
	}

	/**
	 * Internal class for providing an instance of a LTK RefactoringProcessor 
	 * used for EMF model refactorings.	 
	 * @generated
	 */
	public final class InternalRefactoringProcessor extends 
									LtkEmfRefactoringProcessorAdapter {

		/**
		 * Constructor using the invocation context of the model refactoring.
		 * @param selection Invocation context of the model refactoring.
		 * @generated
		 */
		private InternalRefactoringProcessor(List<EObject> selection){
				super(getParent(), selection, applyRefactoring());				
		}
			
		/**
		 * @see org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor#
	 	 * checkInitialConditions(org.eclipse.core.runtime.IProgressMonitor)
		 * @generated
		 */	
		@Override
		public RefactoringStatus checkInitialConditions(){
				RefactoringStatus result = new RefactoringStatus();
				NetworkNode selectedEObject = 
					(NetworkNode) dataManagement.
							getInPortByName(dataManagement.SELECTEDEOBJECT).getValue();
				networkNodePairs = Optimizer.getOptimalNetworkNodePairs(selectedEObject);
				if (networkNodePairs.isEmpty()) {
					result.addFatalError("There is no network node available for optimizing your system!");
				}
				return result;
		}
		
		/**
		 * @see org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor#
	     * checkFinalConditions(org.eclipse.core.runtime.IProgressMonitor, 
	     * org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext)
		 * @generated
		 */	
		@Override
		public RefactoringStatus checkFinalConditions(){
				// no final checks
				return new RefactoringStatus();
		}
		
	}
	
	public List<NetworkNodePair> getNetworkNodePairs() {
		NetworkNode selectedEObject = 
				(NetworkNode) dataManagement.
						getInPortByName(dataManagement.SELECTEDEOBJECT).getValue();
		networkNodePairs = Optimizer.getOptimalNetworkNodePairs(selectedEObject);
		return networkNodePairs;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void setParameters() {
		dataManagement.getInPortByName("networkNodes").setValue(getNetworkNodePairs().get(0));
	}

}