package org.eclipse.emf.refactor.modelsmell.utilities;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

import pam.refactorings.CoolingPair;
import pam.refactorings.NetworkNodePair;
import pam.refactorings.Optimizer;
import pam.refactorings.UninterruptiblePowerSupplyPair;

import PAM.ClientNode;
import PAM.Cooling;
import PAM.NetworkNode;
import PAM.NetworkObjectLink;
import PAM.Room;
import PAM.ServerNode;
import PAM.UninterruptiblePowerSupply;

public class PAMHelper {

	public static List<EObject> getAllCoolings(EObject root) {
		List<EObject> allCoolings = new ArrayList<EObject>();
		TreeIterator<EObject> iter = root.eAllContents();
		while (iter.hasNext()) {
			EObject eObject = iter.next();
			if (eObject instanceof Cooling) {
				allCoolings.add((Cooling) eObject);
			}
		}
		return allCoolings;
	}
	
	public static List<EObject> getAllRooms(EObject root) {
		List<EObject> allRooms = new ArrayList<EObject>();
		TreeIterator<EObject> iter = root.eAllContents();
		while (iter.hasNext()) {
			EObject eObject = iter.next();
			if (eObject instanceof Room) {
				allRooms.add((Room) eObject);
			}
		}
		return allRooms;
	}

	public static List<EObject> getAllServerNodes(EObject root) {
		List<EObject> allServerNodes = new ArrayList<EObject>();
		TreeIterator<EObject> iter = root.eAllContents();
		while (iter.hasNext()) {
			EObject eObject = iter.next();
			if (eObject instanceof ServerNode) {
				allServerNodes.add((ServerNode) eObject);
			}
		}
		return allServerNodes;
	}

	public static List<EObject> getAllClientNodes(EObject root) {
		List<EObject> allClientNodes = new ArrayList<EObject>();
		TreeIterator<EObject> iter = root.eAllContents();
		while (iter.hasNext()) {
			EObject eObject = iter.next();
			if (eObject instanceof ClientNode) {
				allClientNodes.add((ClientNode) eObject);
			}
		}
		return allClientNodes;
	}

	public static List<EObject> getAllNetworkNodes(EObject root) {
		List<EObject> allNetworkNodes = new ArrayList<EObject>();
		TreeIterator<EObject> iter = root.eAllContents();
		while (iter.hasNext()) {
			EObject eObject = iter.next();
			if (eObject instanceof NetworkNode) {
				allNetworkNodes.add((NetworkNode) eObject);
			}
		}
		return allNetworkNodes;
	}

	public static List<EObject> getAllUninterruptiblePowerSupplies(EObject root) {
		List<EObject> allUninterruptiblePowerSupplies = new ArrayList<EObject>();
		TreeIterator<EObject> iter = root.eAllContents();
		while (iter.hasNext()) {
			EObject eObject = iter.next();
			if (eObject instanceof UninterruptiblePowerSupply) {
				allUninterruptiblePowerSupplies.add((UninterruptiblePowerSupply) eObject);
			}
		}
		return allUninterruptiblePowerSupplies;
	}

	public static List<CoolingPair> getCoolingPairsWithinSameRoom(EObject root) {
		List<CoolingPair> coolingPairs = new ArrayList<CoolingPair>();
		List<EObject> allCoolings = getAllCoolings(root);
		for (EObject eObject1 : allCoolings) {
			Cooling cooling1 = (Cooling) eObject1;
			Room room1 = Optimizer.getOwningRoom(cooling1);
			for (EObject eObject2 : allCoolings) {
				if (eObject1 != eObject2) {
					Cooling cooling2 = (Cooling) eObject2;
					Room room2 = Optimizer.getOwningRoom(cooling2);
					if (room1.equals(room2)) {
						CoolingPair pair = new CoolingPair(cooling1, cooling2);
						if (! coolingPairs.contains(pair)) coolingPairs.add(pair);
					}
				}
			}
		}
		return coolingPairs;
	}

	public static List<UninterruptiblePowerSupplyPair> getUPSPairsWithinSameRoom(EObject root) {
		List<UninterruptiblePowerSupplyPair> upsPairs = new ArrayList<UninterruptiblePowerSupplyPair>();
		List<EObject> allUPS = getAllUninterruptiblePowerSupplies(root);
		for (EObject eObject1 : allUPS) {
			UninterruptiblePowerSupply ups1 = (UninterruptiblePowerSupply) eObject1;
			Room room1 = Optimizer.getOwningRoom(ups1);
			for (EObject eObject2 : allUPS) {
				if (eObject1 != eObject2) {
					UninterruptiblePowerSupply ups2 = (UninterruptiblePowerSupply) eObject2;
					Room room2 = Optimizer.getOwningRoom(ups2);
					if (room1.equals(room2)) {
						UninterruptiblePowerSupplyPair pair = new UninterruptiblePowerSupplyPair(ups1, ups2);
						if (! upsPairs.contains(pair)) upsPairs.add(pair);
					}
				}
			} 
		}
		return upsPairs;
	}

	public static List<NetworkNodePair> getConnectedNetworkNodePairs(EObject root) {
		List<NetworkNodePair> nwNodePairs = new ArrayList<NetworkNodePair>();
		List<EObject> allLinks = getAllLinks(root);
		for (EObject eObject : allLinks) {
			NetworkObjectLink link = (NetworkObjectLink) eObject;
			if (link.getConnect0() instanceof NetworkNode) {
				NetworkNodePair pair = new NetworkNodePair((NetworkNode) link.getConnect0(), link.getConnect1());
				if (! nwNodePairs.contains(pair)) nwNodePairs.add(pair);
			}
		}
		return nwNodePairs;
	}

	private static List<EObject> getAllLinks(EObject root) {
		List<EObject> allLinks = new ArrayList<EObject>();
		TreeIterator<EObject> iter = root.eAllContents();
		while (iter.hasNext()) {
			EObject eObject = iter.next();
			if (eObject instanceof NetworkObjectLink) {
				allLinks.add((NetworkObjectLink) eObject);
			}
		}
		return allLinks;
	}
}













