package org.eclipse.emf.refactor.modelsmell.utilities;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.metrics.core.Metric;
import org.eclipse.emf.refactor.metrics.interfaces.IMetricCalculator;

public class GenericStatisticsFunction {
	
	public static double getMaxLimit(List<EObject> eObjects, Metric metric) {
		double average = getAverageMetricValue(eObjects, metric);
		double meanDeviation = getMeanDeviation(eObjects, metric);
		return (average + (meanDeviation / 2));
	}
	
	public static double getMinLimit(List<EObject> eObjects, Metric metric) {
		double average = getAverageMetricValue(eObjects, metric);
		double meanDeviation = getMeanDeviation(eObjects, metric);
		return (average - (meanDeviation / 2));
	}
	
	public static double getMeanDeviation(List<EObject> eObjects, Metric metric) {
		int numberOfElements = eObjects.size();			
		double sumDeviation = getSumDeviation(eObjects, metric);
		if (numberOfElements == 0) return 0;
		return sumDeviation / numberOfElements;
	}
	
	public static double getAverageMetricValue(List<EObject> eObjects, Metric metric) {
		int numberOfElements = eObjects.size();	
		double sumMetricValues = getSumMetricValues(eObjects, metric);
		if (numberOfElements == 0) return 0;
		return sumMetricValues / numberOfElements;
	}

	private static double getSumMetricValues(List<EObject> eObjects, Metric metric) {
		double sum = 0;
		for (EObject eObject : eObjects) {
			IMetricCalculator calc = metric.getCalculateClass();
			List<EObject> con = new ArrayList<EObject>();
			con.add(eObject);
			calc.setContext(con);
			sum += calc.calculate();
		}
		return sum;
	}	
	
	private static double getSumDeviation(List<EObject> eObjects, Metric metric) {
		double average = getAverageMetricValue(eObjects, metric);
		double sumDeviation = 0;
		for (EObject eObject : eObjects) {
			IMetricCalculator calc = metric.getCalculateClass();
			List<EObject> con = new ArrayList<EObject>();
			con.add(eObject);
			calc.setContext(con);
			double value = calc.calculate();
			if (value > average) sumDeviation += (value - average);
			else sumDeviation += (average - value);
		}
		return sumDeviation;
	}

}
