package org.eclipse.emf.refactor.modelsmell;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.modelsmell.utilities.PAMHelper;
import org.eclipse.emf.refactor.smells.interfaces.IModelSmellFinder;

import pam.refactorings.Optimizer;
import PAM.NetworkNode;

public class SubstitutableNetworkNode implements IModelSmellFinder {

	@Override
	public LinkedList<LinkedList<EObject>> findSmell(EObject root) {
		LinkedList<LinkedList<EObject>> results = new LinkedList<LinkedList<EObject>>();
		// custom code
		List<EObject> allNetworkNodes = PAMHelper.getAllNetworkNodes(root);
		for (EObject networkNode : allNetworkNodes) {
			if (! Optimizer.getBetterNetworkNodes((NetworkNode) networkNode).isEmpty()) {
				LinkedList<EObject> result = new LinkedList<EObject>();
				result.add(networkNode);
				results.add(result);
			}
		}
		// end custom code
		return results;
	}

}
