package org.eclipse.emf.refactor.modelsmell;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.modelsmell.utilities.PAMHelper;
import org.eclipse.emf.refactor.smells.interfaces.IModelSmellFinder;

import pam.refactorings.Optimizer;
import PAM.ClientNode;

public class SubstitutableClient implements IModelSmellFinder {

	@Override
	public LinkedList<LinkedList<EObject>> findSmell(EObject root) {
		LinkedList<LinkedList<EObject>> results = new LinkedList<LinkedList<EObject>>();
		// custom code
		List<EObject> allClientNodes = PAMHelper.getAllClientNodes(root);
		for (EObject clientNode : allClientNodes) {
			if (! Optimizer.getBetterClientNodes((ClientNode) clientNode).isEmpty()) {
				LinkedList<EObject> result = new LinkedList<EObject>();
				result.add(clientNode);
				results.add(result);
			}
		}
		// end custom code
		return results;
	}

}
