package org.eclipse.emf.refactor.modelsmell;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.modelsmell.utilities.PAMHelper;
import org.eclipse.emf.refactor.smells.interfaces.IModelSmellFinder;

import pam.refactorings.Optimizer;
import pam.refactorings.UninterruptiblePowerSupplyPair;

public class MergeableUPS implements IModelSmellFinder {

	@Override
	public LinkedList<LinkedList<EObject>> findSmell(EObject root) {
		LinkedList<LinkedList<EObject>> results = new LinkedList<LinkedList<EObject>>();
		// custom code
		List<UninterruptiblePowerSupplyPair> upsPairCandidates = PAMHelper.getUPSPairsWithinSameRoom(root);
		for (UninterruptiblePowerSupplyPair pair : upsPairCandidates) {
			if (! Optimizer.getBetterUPS(pair).isEmpty()) {
				LinkedList<EObject> result = new LinkedList<EObject>();
				result.add(pair.getUps1());
				result.add(pair.getUps2());
				results.add(result);
			}
		}
		// end custom code
		return results;
	}

}
