package org.eclipse.emf.refactor.modelsmell;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.modelsmell.utilities.PAMHelper;
import org.eclipse.emf.refactor.smells.interfaces.IModelSmellFinder;

import pam.refactorings.NetworkNodePair;
import pam.refactorings.Optimizer;

public class MergeableNetworkNode implements IModelSmellFinder {

	@Override
	public LinkedList<LinkedList<EObject>> findSmell(EObject root) {
		LinkedList<LinkedList<EObject>> results = new LinkedList<LinkedList<EObject>>();
		// custom code
		List<NetworkNodePair> nwPairCandidates = PAMHelper.getConnectedNetworkNodePairs(root);
		for (NetworkNodePair pair : nwPairCandidates) {
			if (! Optimizer.getBetterNetworkNode(pair).isEmpty()) {
				LinkedList<EObject> result = new LinkedList<EObject>();
				result.add(pair.getNode1());
				result.add(pair.getNode2());
				results.add(result);
			}
		}
		// end custom code
		return results;
	}

}
