package org.eclipse.emf.refactor.modelsmell;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.modelsmell.utilities.PAMHelper;
import org.eclipse.emf.refactor.smells.interfaces.IModelSmellFinder;

import pam.refactorings.CoolingPair;
import pam.refactorings.Optimizer;

public class MergeableCoolings implements IModelSmellFinder {

	@Override
	public LinkedList<LinkedList<EObject>> findSmell(EObject root) {
		LinkedList<LinkedList<EObject>> results = new LinkedList<LinkedList<EObject>>();
		// custom code
		List<CoolingPair> coolingPairCandidates = PAMHelper.getCoolingPairsWithinSameRoom(root);
		for (CoolingPair pair : coolingPairCandidates) {
			if (! Optimizer.getBetterCooling(pair).isEmpty()) {
				LinkedList<EObject> result = new LinkedList<EObject>();
				result.add(pair.getCooling1());
				result.add(pair.getCooling2());
				results.add(result);
			}
		}
		// end custom code
		return results;
	}

}
