package org.eclipse.emf.refactor.modelsmell;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.metrics.core.Metric;
import org.eclipse.emf.refactor.metrics.interfaces.IMetricCalculator;
import org.eclipse.emf.refactor.modelsmell.utilities.GenericStatisticsFunction;
import org.eclipse.emf.refactor.modelsmell.utilities.PAMHelper;
import org.eclipse.emf.refactor.smells.interfaces.IModelSmellFinder;

public class LowOPWClientValue implements IModelSmellFinder {

	@Override
	public LinkedList<LinkedList<EObject>> findSmell(EObject root) {
		LinkedList<LinkedList<EObject>> results = new LinkedList<LinkedList<EObject>>();
		// custom code
		List<EObject> allClientNodes = PAMHelper.getAllClientNodes(root);
		Metric metric = Metric.getMetricInstanceFromId("pam.opwclient");
		double minLimit = GenericStatisticsFunction.getMinLimit(allClientNodes, metric);
		System.out.println("---> OPW Client: minLimit is " + minLimit);
		for (EObject clientNode : allClientNodes) {
			IMetricCalculator calc = metric.getCalculateClass();
			List<EObject> con = new ArrayList<EObject>();
			con.add(clientNode);
			calc.setContext(con);
			double value = calc.calculate();
			if (value < minLimit) {
				LinkedList<EObject> result = new LinkedList<EObject>();
				result.add(clientNode);
				results.add(result);
			}
		}
		// end custom code
		return results;
	}

}
