package org.eclipse.emf.refactor.modelsmell;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.metrics.core.Metric;
import org.eclipse.emf.refactor.metrics.interfaces.IMetricCalculator;
import org.eclipse.emf.refactor.modelsmell.utilities.GenericStatisticsFunction;
import org.eclipse.emf.refactor.modelsmell.utilities.PAMHelper;
import org.eclipse.emf.refactor.smells.interfaces.IModelSmellFinder;

public class HighOPWServerValue implements IModelSmellFinder {

	@Override
	public LinkedList<LinkedList<EObject>> findSmell(EObject root) {
		LinkedList<LinkedList<EObject>> results = new LinkedList<LinkedList<EObject>>();
		// custom code
		List<EObject> allServerNodes = PAMHelper.getAllServerNodes(root);
		Metric metric = Metric.getMetricInstanceFromId("pam.opwserver");
		double maxLimit = GenericStatisticsFunction.getMaxLimit(allServerNodes, metric);
		System.out.println("---> OPW Server: maxLimit is " + maxLimit);
		for (EObject cooling : allServerNodes) {
			IMetricCalculator calc = metric.getCalculateClass();
			List<EObject> con = new ArrayList<EObject>();
			con.add(cooling);
			calc.setContext(con);
			double value = calc.calculate();
			if (value > maxLimit) {
				LinkedList<EObject> result = new LinkedList<EObject>();
				result.add(cooling);
				results.add(result);
			}
		}
		// end custom code
		return results;
	}

}
