package org.eclipse.emf.refactor.modelsmell;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.metrics.core.Metric;
import org.eclipse.emf.refactor.metrics.interfaces.IMetricCalculator;
import org.eclipse.emf.refactor.modelsmell.utilities.GenericStatisticsFunction;
import org.eclipse.emf.refactor.modelsmell.utilities.PAMHelper;
import org.eclipse.emf.refactor.smells.interfaces.IModelSmellFinder;

public class HighCRLValue implements IModelSmellFinder {

	@Override
	public LinkedList<LinkedList<EObject>> findSmell(EObject root) {
		LinkedList<LinkedList<EObject>> results = new LinkedList<LinkedList<EObject>>();
		// custom code
		List<EObject> allUninterruptiblePowerSupplies = PAMHelper.getAllUninterruptiblePowerSupplies(root);
		Metric metric = Metric.getMetricInstanceFromId("pam.crl");
		double maxLimit = GenericStatisticsFunction.getMaxLimit(allUninterruptiblePowerSupplies, metric);
		System.out.println("---> CRL: maxLimit is " + maxLimit);
		for (EObject cooling : allUninterruptiblePowerSupplies) {
			IMetricCalculator calc = metric.getCalculateClass();
			List<EObject> con = new ArrayList<EObject>();
			con.add(cooling);
			calc.setContext(con);
			double value = calc.calculate();
			if (value > maxLimit) {
				LinkedList<EObject> result = new LinkedList<EObject>();
				result.add(cooling);
				results.add(result);
			}
		}
		// end custom code
		return results;
	}

}
