package org.eclipse.emf.refactor.modelsmell;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.modelsmell.utilities.PAMHelper;
import org.eclipse.emf.refactor.smells.interfaces.IModelSmellFinder;

import pam.refactorings.Optimizer;
import PAM.UninterruptiblePowerSupply;

public class DeletableUPS implements IModelSmellFinder {

	@Override
	public LinkedList<LinkedList<EObject>> findSmell(EObject root) {
		LinkedList<LinkedList<EObject>> results = new LinkedList<LinkedList<EObject>>();
		// custom code
		List<EObject> allUPSs = PAMHelper.getAllUninterruptiblePowerSupplies(root);
		for (EObject eObject : allUPSs) {
			UninterruptiblePowerSupply ups = (UninterruptiblePowerSupply) eObject;
			if (Optimizer.isOptimalDeletable(ups)) {
				LinkedList<EObject> result = new LinkedList<EObject>();
				result.add(ups);
				results.add(result);
			}
		}
		// end custom code
		return results;
	}

}
