package org.eclipse.emf.refactor.metrics;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.metrics.core.Metric;
import org.eclipse.emf.refactor.metrics.interfaces.IMetricCalculator;

import PAM.Cooling;
import PAM.Nodes;
import PAM.Room;
import PAM.UninterruptiblePowerSupply;


public final class PUE implements IMetricCalculator {

	private List<EObject> context; 
		
	@Override
	public void setContext(List<EObject> context) {
		this.context = context;
	}	
		
	@SuppressWarnings("unchecked")
	@Override
	public double calculate() {	
		Room room = (Room) context.get(0);
		double totalEnergyConsumption = 0;
		double consumptionOfITEquipment = 0;
		List<Room> allRooms = getAllRooms(room);
		for (Room r : allRooms) {
			EList<Nodes> nodes = r.getContains();
			for (Nodes n : nodes) {
				totalEnergyConsumption += n.getMax_Watt();
				consumptionOfITEquipment += n.getMax_Watt();
			}
			EList<Cooling> coolings = r.getIncludes();
			for (Cooling c : coolings) {
				totalEnergyConsumption += c.getMax_Watt();
			}
			EList<UninterruptiblePowerSupply> upss = r.getApplies();
			Metric metric = Metric.getMetricInstanceFromId("pam.crl");
			for (UninterruptiblePowerSupply ups : upss) {
				IMetricCalculator calc = metric.getCalculateClass();
				List<EObject> con = new ArrayList<EObject>();
				con.add(ups);
				calc.setContext(con);
				totalEnergyConsumption += calc.calculate();
			}
		}		
		if (consumptionOfITEquipment == 0) return Double.NaN;
		else {
			System.out.println("totalEnergyConsumption: " + totalEnergyConsumption);
			System.out.println("consumptionOfITEquipment: " + consumptionOfITEquipment);
			return totalEnergyConsumption / consumptionOfITEquipment;
		}
	}

	@SuppressWarnings("unchecked")
	private List<Room> getAllRooms(Room room) {
		List<Room> allRooms = new ArrayList<Room>();
		allRooms.add(room); 
		EList<Room> subrooms = room.getSubrooms();
		for (Room room1 : subrooms) {
			allRooms.addAll(getAllRooms(room1));
		}		
		return allRooms;
	}
}