package org.eclipse.emf.refactor.metrics;

import java.util.List;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.metrics.interfaces.IMetricCalculator;

import PAM.Room;


public final class NEL implements IMetricCalculator {

	private List<EObject> context; 
		
	@Override
	public void setContext(List<EObject> context) {
		this.context = context;
	}	
		
	@Override
	public double calculate() {	
		EObject contextObject = context.get(0);
		Room room = (Room) contextObject;
		TreeIterator<EObject> iter = room.eAllContents();
		double ret = 1;
		while (iter.hasNext()) {
			ret++;
			iter.next();
		}
		return ret;
	}
}