package org.eclipse.emf.refactor.examples.simpleWebModel;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class SimpleWebModelHelper {
	
	public static boolean isReferencedByDynamicPage(Entity entity, EObject root) {
		List<DynamicPage> dynamicPages = SimpleWebModelHelper.getAllDynamicPages(root);
		boolean isReferencedByDynamicPage = false;
		for (DynamicPage dynamicPage : dynamicPages) {
			if (dynamicPage.getEntity() == entity) {
				isReferencedByDynamicPage = true;
			}
		}
		return isReferencedByDynamicPage;
	}
	
	public static boolean isReferencedByEntity(Entity entity, EObject root) {
		List<Entity> entities = SimpleWebModelHelper.getAllEntities(root);
		boolean isReferencedByEntity = false;
		for (Entity otherEntity : entities) { 
			if (entity != otherEntity) {
				for (Reference ref : otherEntity.getReferences()) {
					if (ref.getType() == entity) {
						isReferencedByEntity = true;
					}
				}
			}
		}
		return isReferencedByEntity;
	}

	public static List<Entity> getAllEntities(EObject root) {
		List<Entity> entities = new ArrayList<Entity>();
		TreeIterator<EObject> iter = root.eAllContents();
		while (iter.hasNext()) {
			EObject eObject = iter.next();
			if (eObject instanceof Entity) {
				entities.add((Entity) eObject);
			}
		}
		return entities;
	}
	
	private static List<DynamicPage> getAllDynamicPages(EObject root) {
		List<DynamicPage> dynamicPages = new ArrayList<DynamicPage>();
		TreeIterator<EObject> iter = root.eAllContents();
		while (iter.hasNext()) {
			EObject eObject = iter.next();
			if (eObject instanceof DynamicPage) {
				dynamicPages.add((DynamicPage) eObject);
			}
		}
		return dynamicPages;
	}
}