package org.eclipse.emf.refactor.modelsmell;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.examples.simpleWebModel.DynamicPage;
import org.eclipse.emf.refactor.examples.simpleWebModel.Entity;
import org.eclipse.emf.refactor.examples.simpleWebModel.Reference;
import org.eclipse.emf.refactor.examples.swm.xtext.techniques.SWMHelper;
import org.eclipse.emf.refactor.smells.interfaces.IModelSmellFinder;

public class UnusedEntity implements IModelSmellFinder {

	@Override
	public LinkedList<LinkedList<EObject>> findSmell(EObject root) {
		LinkedList<LinkedList<EObject>> results = new LinkedList<LinkedList<EObject>>();
		// start custom code
		List<DynamicPage> dynamicPages = SWMHelper.getAllDynamicPages(root);
		List<Entity> entities = SWMHelper.getAllEntities(root);
		for (Entity candidate : entities) {
			boolean referenced = false;
			for (Entity entity : entities) {
				if (entity != candidate) {
					for (Reference reference : entity.getReferences()) {
						if (reference.getType() == candidate) {
							referenced = true;
						}
					}
				}
			}
			for (DynamicPage dynamicPage : dynamicPages) {
				if (dynamicPage.getEntity() == candidate) {
					referenced = true;
				}
			}
			if (! referenced) {
				LinkedList<EObject> result = new LinkedList<EObject>();
				result.add(candidate);
				results.add(result);
			}
		}		
		// end custom code
		return results;
	}

}
