package org.eclipse.emf.refactor.examples.swm.xtext.techniques;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.refactor.examples.simpleWebModel.DataPage;
import org.eclipse.emf.refactor.examples.simpleWebModel.DynamicPage;
import org.eclipse.emf.refactor.examples.simpleWebModel.Entity;
import org.eclipse.emf.refactor.examples.simpleWebModel.IndexPage;
import org.eclipse.emf.refactor.examples.simpleWebModel.Page;
import org.eclipse.emf.refactor.examples.simpleWebModel.StaticPage;
import org.eclipse.emf.refactor.examples.simpleWebModel.WebModel;

public class SWMHelper {
	
	public static List<StaticPage> getAllStaticPages(EObject eObject) {
		EObject rootElement = EcoreUtil.getRootContainer(eObject);
		List<StaticPage> staticPages = new ArrayList<StaticPage>();
		TreeIterator<EObject> iter = rootElement.eAllContents();
		while (iter.hasNext()) {
			EObject elem = iter.next();
			if (elem instanceof StaticPage) {
				StaticPage staticPage = (StaticPage) elem;
				staticPages.add(staticPage);
			}
		}
		return staticPages;
	}
	
	public static StaticPage getStartPage(EObject eObject) {
		EObject rootElement = EcoreUtil.getRootContainer(eObject);
		WebModel webModel = (WebModel) rootElement;
		StaticPage startPage = null;
		if (webModel.getHypertextLayer().getStartPage() != null) {
			startPage = webModel.getHypertextLayer().getStartPage();
		}
		return startPage;
	}

	public static List<IndexPage> getAllIndexPages(EObject eObject) {
		EObject rootElement = EcoreUtil.getRootContainer(eObject);
		List<IndexPage> indexPages = new ArrayList<IndexPage>();
		TreeIterator<EObject> iter = rootElement.eAllContents();
		while (iter.hasNext()) {
			EObject elem = iter.next();
			if (elem instanceof IndexPage) {
				IndexPage indexPage = (IndexPage) elem;
				indexPages.add(indexPage);
			}
		}
		return indexPages;
	}
	
	public static List<DataPage> getAllDataPages(EObject eObject) {
		EObject rootElement = EcoreUtil.getRootContainer(eObject);
		List<DataPage> dataPages = new ArrayList<DataPage>();
		TreeIterator<EObject> iter = rootElement.eAllContents();
		while (iter.hasNext()) {
			EObject elem = iter.next();
			if (elem instanceof DataPage) {
				DataPage dataPage = (DataPage) elem;
				dataPages.add(dataPage);
			}
		}
		return dataPages;
	}

	public static List<Page> getAllPages(EObject eObject) {
		EObject rootElement = EcoreUtil.getRootContainer(eObject);
		List<Page> pages = new ArrayList<Page>();
		TreeIterator<EObject> iter = rootElement.eAllContents();
		while (iter.hasNext()) {
			EObject elem = iter.next();
			if (elem instanceof Page) {
				pages.add((Page) elem);
			}
		}
		return pages;
	}
	
	public static List<DynamicPage> getAllDynamicPages(EObject eObject) {
		EObject rootElement = EcoreUtil.getRootContainer(eObject);
		List<DynamicPage> dynamicPages = new ArrayList<DynamicPage>();
		TreeIterator<EObject> iter = rootElement.eAllContents();
		while (iter.hasNext()) {
			EObject elem = iter.next();
			if (elem instanceof DynamicPage) {
				dynamicPages.add((DynamicPage) elem);
			}
		}
		return dynamicPages;
	}
	
	public static List<Entity> getAllEntities(EObject eObject) {
		EObject rootElement = EcoreUtil.getRootContainer(eObject);
		List<Entity> entities = new ArrayList<Entity>();
		TreeIterator<EObject> iter = rootElement.eAllContents();
		while (iter.hasNext()) {
			EObject elem = iter.next();
			if (elem instanceof Entity) {
				entities.add((Entity) elem);
			}
		}
		return entities;
	}
	
	
}
