/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.force.model;

import java.util.List;
import java.util.Random;
import org.eclipse.elk.alg.force.graph.FBendpoint;
import org.eclipse.elk.alg.force.graph.FEdge;
import org.eclipse.elk.alg.force.graph.FGraph;
import org.eclipse.elk.alg.force.graph.FLabel;
import org.eclipse.elk.alg.force.graph.FNode;
import org.eclipse.elk.alg.force.graph.FParticle;
import org.eclipse.elk.alg.force.options.ForceOptions;
import org.eclipse.elk.alg.force.options.InternalProperties;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public abstract class AbstractForceModel {
    private Random random;
    private FGraph graph;
    private double dispBound;
    private static final double DISP_BOUND_FACTOR = 16.0;

    protected void initialize(FGraph fgraph) {
        this.graph = fgraph;
        this.random = (Random)fgraph.getProperty(InternalProperties.RANDOM);
        fgraph.calcAdjacency();
        this.dispBound = Math.max((double)fgraph.getNodes().size() * 16.0 + (double)fgraph.getEdges().size(), 256.0);
        if (!((Boolean)fgraph.getProperty(ForceOptions.INTERACTIVE)).booleanValue()) {
            double posScale = this.graph.getNodes().size();
            for (FNode node : fgraph.getNodes()) {
                KVector pos = node.getPosition();
                pos.x = this.random.nextDouble() * posScale;
                pos.y = this.random.nextDouble() * posScale;
            }
        }
        List<FBendpoint> bends = fgraph.getBendpoints();
        for (FEdge edge : fgraph.getEdges()) {
            int count = (Integer)edge.getProperty(ForceOptions.REPULSIVE_POWER);
            if (count <= 0) continue;
            int i = 0;
            while (i < count) {
                bends.add(new FBendpoint(edge));
                ++i;
            }
            edge.distributeBendpoints();
        }
    }

    public final FGraph getGraph() {
        return this.graph;
    }

    protected final Random getRandom() {
        return this.random;
    }

    public void layout(FGraph fgraph, IElkProgressMonitor monitor) {
        monitor.begin("Component Layout", 1.0f);
        this.initialize(fgraph);
        int iterations = 0;
        while (this.moreIterations(iterations) && !monitor.isCanceled()) {
            this.iterationDone();
            for (FParticle v : fgraph.getParticles()) {
                for (FParticle u : fgraph.getParticles()) {
                    KVector displacement;
                    if (u == v || (displacement = this.calcDisplacement(u, v)) == null) continue;
                    v.getDisplacement().add(displacement);
                }
            }
            for (FParticle v : fgraph.getParticles()) {
                KVector d = v.getDisplacement();
                d.bound(-this.dispBound, -this.dispBound, this.dispBound, this.dispBound);
                v.getPosition().add(d);
                d.reset();
            }
            ++iterations;
        }
        monitor.done();
    }

    protected void iterationDone() {
        for (FEdge edge : this.graph.getEdges()) {
            for (FLabel label : edge.getLabels()) {
                label.refreshPosition();
            }
            edge.distributeBendpoints();
        }
    }

    protected abstract boolean moreIterations(int var1);

    protected abstract KVector calcDisplacement(FParticle var1, FParticle var2);

    public static void avoidSamePosition(Random random, FParticle u, FParticle v) {
        KVector pu = u.getPosition();
        KVector pv = v.getPosition();
        while (pu.x - pv.x == 0.0 && pu.y - pv.y == 0.0) {
            boolean triedForBendPoints = false;
            if (u instanceof FBendpoint && v instanceof FBendpoint && !triedForBendPoints) {
                FEdge uE = ((FBendpoint)u).getEdge();
                KVector uVector = new KVector(uE.getTargetPoint()).sub(uE.getSourcePoint());
                double length = 2.0;
                KVector orthogonaluV = new KVector(uVector.x / uVector.length() * length, -uVector.y / uVector.length() * length);
                pu.add(orthogonaluV);
                FEdge vE = ((FBendpoint)v).getEdge();
                KVector vVector = new KVector(vE.getTargetPoint()).sub(vE.getSourcePoint());
                length = uVector == vVector ? -2 : 2;
                KVector orthogonalvV = new KVector(vVector.x / vVector.length() * length, -(vVector.y / vVector.length()) * length);
                pu.add(orthogonalvV);
                triedForBendPoints = true;
                continue;
            }
            pu.wiggle(random, 1.0);
            pv.wiggle(random, 1.0);
        }
    }
}

