/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.options;

import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.graph.ElkNode;

public class TopdownSizeApproximatorUtil {
    public static double getSizeCategoryMultiplier(ElkNode originalGraph) {
        ElkNode parent = originalGraph.getParent();
        int thisGraphsSize = TopdownSizeApproximatorUtil.getGraphSize(originalGraph);
        int CATEGORIES = (Integer)originalGraph.getProperty(CoreOptions.TOPDOWN_SIZE_CATEGORIES);
        if (parent != null) {
            int sizeMinFound = Integer.MAX_VALUE;
            int sizeMaxFound = Integer.MIN_VALUE;
            for (ElkNode child : parent.getChildren()) {
                int size = TopdownSizeApproximatorUtil.getGraphSize(child);
                if (size > sizeMaxFound) {
                    sizeMaxFound = size;
                }
                if (size >= sizeMinFound) continue;
                sizeMinFound = size;
            }
            double sizeMin = 1.0;
            double sizeMax = Math.pow(4.0, CATEGORIES);
            if ((double)sizeMaxFound > sizeMax) {
                sizeMax = sizeMaxFound;
            }
            double x = (Math.log(sizeMax) - Math.log(sizeMin)) / (double)CATEGORIES;
            double factor = Math.exp(x);
            double cutoff = sizeMin * factor;
            int i = 0;
            while (i < CATEGORIES) {
                if ((double)thisGraphsSize < cutoff) {
                    return Math.pow(2.0, i);
                }
                cutoff *= factor;
                ++i;
            }
            return Math.pow(2.0, CATEGORIES - 1);
        }
        return 1.0;
    }

    public static int getGraphSize(ElkNode originalGraph) {
        int sum = 0;
        int HIERARCHICAL_NODE_WEIGHT = (Integer)originalGraph.getProperty(CoreOptions.TOPDOWN_SIZE_CATEGORIES_HIERARCHICAL_NODE_WEIGHT);
        for (ElkNode child : originalGraph.getChildren()) {
            if (child.getChildren() != null && child.getChildren().size() > 0) {
                sum += HIERARCHICAL_NODE_WEIGHT;
                continue;
            }
            ++sum;
        }
        return sum;
    }
}

