/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.ActionUtils;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.dialogs.HyperlinkSourceViewer;
import org.eclipse.egit.ui.internal.dialogs.HyperlinkTokenScanner;
import org.eclipse.egit.ui.internal.dialogs.ShowWhitespaceAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.CommitConfig;
import org.eclipse.jgit.util.IntList;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class SpellcheckableMessageArea
extends Composite {
    static final int MAX_LINE_WIDTH = 72;
    private static final Pattern TRAILING_WHITE_SPACE_ON_LINES = Pattern.compile("\\h+$", 8);
    private static final Pattern TRAILING_NEWLINES = Pattern.compile("\\v+$");
    private static final String COMMENT_CONTENT_TYPE = "_egit_commit_message_comment";
    private final HyperlinkSourceViewer sourceViewer;
    private TextSourceViewerConfiguration configuration;
    private BidiSegmentListener hardWrapSegmentListener;
    private int brokenBidiPlatformTextWidth;
    private IAction contentAssistAction;
    private Token commentColoring;
    @NonNull
    private CommitConfig.CleanupMode cleanupMode = CommitConfig.CleanupMode.STRIP;
    private char commentChar = (char)35;
    private CopyOnWriteArrayList<Runnable> cleanupChangeListeners = new CopyOnWriteArrayList();

    public SpellcheckableMessageArea(Composite parent, String initialText, int styles) {
        this(parent, initialText, false, styles);
    }

    public SpellcheckableMessageArea(Composite parent, String initialText, boolean readOnly, int styles) {
        super(parent, styles);
        this.setLayout((Layout)new FillLayout());
        final boolean useCommentHighlight = !readOnly;
        AnnotationModel annotationModel = new AnnotationModel();
        this.sourceViewer = new HyperlinkSourceViewer(this, null, 2 | this.getViewerStyles()){

            @Override
            protected void handleJFacePreferencesChange(PropertyChangeEvent event) {
                if ("org.eclipse.jface.textfont".equals(event.getProperty())) {
                    Font jFaceFont;
                    Font themeFont = UIUtils.getFont("org.eclipse.egit.ui.CommitMessageEditorFont");
                    if (themeFont.equals((Object)(jFaceFont = JFaceResources.getTextFont()))) {
                        this.setFont(jFaceFont);
                    }
                } else {
                    super.handleJFacePreferencesChange(event);
                }
            }
        };
        this.getTextWidget().setAlwaysShowScrollBars(false);
        this.getTextWidget().setFont(UIUtils.getFont("org.eclipse.egit.ui.CommitMessageEditorFont"));
        this.sourceViewer.setDocument((IDocument)new Document());
        int endSpacing = 2;
        int textWidth = (int)(this.getCharWidth() * 72.0 + (double)endSpacing);
        int textHeight = this.getLineHeight() * 7;
        Point size = this.getTextWidget().computeSize(textWidth, textHeight);
        this.getTextWidget().setSize(size);
        this.computeBrokenBidiPlatformTextWidth(size.x);
        this.getTextWidget().setEditable(!readOnly);
        this.createMarginPainter();
        this.configureHardWrap();
        final IPropertyChangeListener propertyChangeListener = event -> {
            if ("commit_dialog_hard_wrap_message".equals(event.getProperty())) {
                this.getDisplay().asyncExec(() -> {
                    if (!this.isDisposed()) {
                        this.configureHardWrap();
                        if (this.brokenBidiPlatformTextWidth != -1) {
                            this.layout();
                        }
                    }
                });
            }
        };
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(propertyChangeListener);
        if (useCommentHighlight) {
            ColorRegistry colors = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
            this.commentColoring = new Token((Object)new TextAttribute(colors.get("org.eclipse.egit.ui.CommitMessageCommentColor")));
        }
        final IPropertyChangeListener themeListener = event -> {
            String property = event.getProperty();
            if ("CHANGE_CURRENT_THEME".equals(property) || "org.eclipse.egit.ui.CommitMessageEditorFont".equals(property) || this.commentColoring != null && "org.eclipse.egit.ui.CommitMessageCommentColor".equals(property)) {
                Font themeFont = UIUtils.getFont("org.eclipse.egit.ui.CommitMessageEditorFont");
                ColorRegistry colors = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
                this.getDisplay().asyncExec(() -> {
                    if (!this.isDisposed()) {
                        this.sourceViewer.setFont(themeFont);
                        if (this.commentColoring != null) {
                            this.commentColoring.setData((Object)new TextAttribute(colors.get("org.eclipse.egit.ui.CommitMessageCommentColor")));
                            this.sourceViewer.invalidateTextPresentation();
                        }
                    }
                });
            }
        };
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(themeListener);
        final SourceViewerDecorationSupport support = this.configureAnnotationPreferences();
        Document document = new Document(initialText);
        this.configuration = new HyperlinkSourceViewer.Configuration(EditorsUI.getPreferenceStore()){

            public int getHyperlinkStateMask(ISourceViewer targetViewer) {
                if (!targetViewer.isEditable()) {
                    return 0;
                }
                return super.getHyperlinkStateMask(targetViewer);
            }

            @Override
            protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer targetViewer) {
                return SpellcheckableMessageArea.this.getHyperlinkTargets();
            }

            public IReconciler getReconciler(ISourceViewer viewer) {
                if (!SpellcheckableMessageArea.this.isEditable(viewer)) {
                    return null;
                }
                return super.getReconciler((ISourceViewer)SpellcheckableMessageArea.this.sourceViewer);
            }

            public IContentAssistant getContentAssistant(ISourceViewer viewer) {
                if (!viewer.isEditable()) {
                    return null;
                }
                IContentAssistant assistant = SpellcheckableMessageArea.this.createContentAssistant(viewer);
                if (assistant != null) {
                    SpellcheckableMessageArea.this.contentAssistAction = SpellcheckableMessageArea.this.createContentAssistAction((SourceViewer)SpellcheckableMessageArea.this.sourceViewer);
                }
                return assistant;
            }

            public String[] getConfiguredContentTypes(ISourceViewer viewer) {
                if (!useCommentHighlight) {
                    return super.getConfiguredContentTypes(viewer);
                }
                return new String[]{"__dftl_partition_content_type", SpellcheckableMessageArea.COMMENT_CONTENT_TYPE};
            }

            public IPresentationReconciler getPresentationReconciler(ISourceViewer viewer) {
                PresentationReconciler reconciler = new PresentationReconciler();
                reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(viewer));
                DefaultDamagerRepairer hyperlinkDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)new HyperlinkTokenScanner((SourceViewerConfiguration)this, viewer));
                reconciler.setDamager((IPresentationDamager)hyperlinkDamagerRepairer, "__dftl_partition_content_type");
                reconciler.setRepairer((IPresentationRepairer)hyperlinkDamagerRepairer, "__dftl_partition_content_type");
                if (useCommentHighlight) {
                    DefaultDamagerRepairer commentRepairer = new DefaultDamagerRepairer((ITokenScanner)new HyperlinkTokenScanner((SourceViewerConfiguration)this, viewer, SpellcheckableMessageArea.this.commentColoring));
                    reconciler.setDamager((IPresentationDamager)commentRepairer, SpellcheckableMessageArea.COMMENT_CONTENT_TYPE);
                    reconciler.setRepairer((IPresentationRepairer)commentRepairer, SpellcheckableMessageArea.COMMENT_CONTENT_TYPE);
                }
                return reconciler;
            }
        };
        this.sourceViewer.configure((SourceViewerConfiguration)this.configuration);
        if (useCommentHighlight) {
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new CommitPartitionTokenScanner(() -> this.commentChar, () -> this.cleanupMode), this.configuration.getConfiguredContentTypes((ISourceViewer)this.sourceViewer));
            partitioner.connect((IDocument)document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        this.sourceViewer.setDocument((IDocument)document, (IAnnotationModel)annotationModel);
        this.configureContextMenu();
        this.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                support.uninstall();
                SpellcheckableMessageArea.this.cleanupChangeListeners.clear();
                Activator.getDefault().getPreferenceStore().removePropertyChangeListener(propertyChangeListener);
                PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(themeListener);
            }
        });
    }

    protected int getViewerStyles() {
        return 576;
    }

    private void computeBrokenBidiPlatformTextWidth(int textWidth) {
        class BidiSegmentListenerTester
        implements BidiSegmentListener {
            boolean called;

            BidiSegmentListenerTester() {
            }

            public void lineGetSegments(BidiSegmentEvent event) {
                this.called = true;
            }
        }
        BidiSegmentListenerTester tester = new BidiSegmentListenerTester();
        StyledText textWidget = this.getTextWidget();
        textWidget.addBidiSegmentListener((BidiSegmentListener)tester);
        textWidget.setText(" ");
        textWidget.computeSize(-1, -1);
        textWidget.removeBidiSegmentListener((BidiSegmentListener)tester);
        this.brokenBidiPlatformTextWidth = tester.called ? -1 : textWidth;
    }

    private boolean isEditable(ISourceViewer viewer) {
        return viewer != null && viewer.isEditable();
    }

    protected void configureHardWrap() {
        if (SpellcheckableMessageArea.shouldHardWrap()) {
            if (this.hardWrapSegmentListener == null) {
                final StyledText textWidget = this.getTextWidget();
                this.hardWrapSegmentListener = new BidiSegmentListener(){

                    public void lineGetSegments(BidiSegmentEvent e) {
                        int footerOffset;
                        if (e.widget == textWidget && (footerOffset = CommonUtils.getFooterOffset(textWidget.getText())) >= 0 && e.lineOffset >= footerOffset) {
                            return;
                        }
                        int[] segments = SpellcheckableMessageArea.calculateWrapOffsets(e.lineText, 72, SpellcheckableMessageArea.this.commentChar);
                        if (segments != null) {
                            char[] segmentsChars = new char[segments.length];
                            Arrays.fill(segmentsChars, '\n');
                            e.segments = segments;
                            e.segmentsChars = segmentsChars;
                        }
                    }
                };
                textWidget.addBidiSegmentListener(this.hardWrapSegmentListener);
                textWidget.setText(textWidget.getText());
                if (this.brokenBidiPlatformTextWidth != -1) {
                    Layout restrictedWidthLayout = new Layout(){

                        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                            Point size = SpellcheckableMessageArea.this.getSize();
                            Rectangle trim = SpellcheckableMessageArea.this.computeTrim(0, 0, 0, 0);
                            size.x -= trim.width;
                            size.y -= trim.height;
                            if (size.x > SpellcheckableMessageArea.this.brokenBidiPlatformTextWidth) {
                                size.x = SpellcheckableMessageArea.this.brokenBidiPlatformTextWidth;
                            }
                            return size;
                        }

                        protected void layout(Composite composite, boolean flushCache) {
                            Point size = this.computeSize(composite, -1, -1, flushCache);
                            textWidget.setBounds(0, 0, size.x, size.y);
                        }
                    };
                    this.setLayout(restrictedWidthLayout);
                }
            }
        } else if (this.hardWrapSegmentListener != null) {
            StyledText textWidget = this.getTextWidget();
            textWidget.removeBidiSegmentListener(this.hardWrapSegmentListener);
            textWidget.setText(textWidget.getText());
            this.hardWrapSegmentListener = null;
            if (this.brokenBidiPlatformTextWidth != -1) {
                this.setLayout((Layout)new FillLayout());
            }
        }
    }

    private void configureContextMenu() {
        boolean editable = this.isEditable((ISourceViewer)this.sourceViewer);
        QuickfixAction quickFixAction = null;
        if (editable) {
            quickFixAction = new QuickfixAction((ITextOperationTarget)this.sourceViewer);
        }
        ShowWhitespaceAction showWhitespaceAction = new ShowWhitespaceAction((ITextViewer)this.sourceViewer, !editable);
        MenuManager contextMenu = new MenuManager();
        ActionUtils.UpdateableAction[] standardActions = ActionUtils.fillStandardTextActions((ITextOperationTarget)this.sourceViewer, editable, contextMenu);
        contextMenu.add((IContributionItem)new Separator());
        contextMenu.add((IAction)showWhitespaceAction);
        contextMenu.add((IContributionItem)new Separator());
        if (editable) {
            final SubMenuManager quickFixMenu = new SubMenuManager((IMenuManager)contextMenu);
            quickFixMenu.setVisible(true);
            quickFixMenu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    quickFixMenu.removeAll();
                    SpellcheckableMessageArea.this.addProposals(quickFixMenu);
                }
            });
        }
        StyledText textWidget = this.getTextWidget();
        ArrayList<Object> globalActions = new ArrayList<Object>();
        globalActions.addAll(Arrays.asList(standardActions));
        if (quickFixAction != null) {
            globalActions.add((Object)quickFixAction);
        }
        if (this.contentAssistAction != null) {
            globalActions.add(this.contentAssistAction);
        }
        ActionUtils.setGlobalActions((Control)textWidget, globalActions, this.getHandlerService());
        textWidget.setMenu(contextMenu.createContextMenu((Control)textWidget));
        this.sourceViewer.addSelectionChangedListener(event -> {
            if (standardActions[3] != null) {
                standardActions[3].update();
            }
            standardActions[4].update();
        });
        if (editable) {
            this.sourceViewer.addTextListener(event -> {
                if (standardActions[1] != null) {
                    standardActions[1].update();
                }
                if (standardActions[2] != null) {
                    standardActions[2].update();
                }
            });
        }
        textWidget.addDisposeListener(e -> showWhitespaceAction.dispose());
    }

    private void addProposals(SubMenuManager quickFixMenu) {
        IAnnotationModel sourceModel = this.sourceViewer.getAnnotationModel();
        if (sourceModel == null) {
            return;
        }
        Iterator annotationIterator = sourceModel.getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            ICompletionProposal[] proposals;
            boolean isFixable;
            Annotation annotation = (Annotation)annotationIterator.next();
            boolean isDeleted = annotation.isMarkedDeleted();
            boolean isIncluded = !isDeleted && this.includes(sourceModel.getPosition(annotation), this.getTextWidget().getCaretOffset());
            boolean bl = isFixable = isIncluded && this.sourceViewer.getQuickAssistAssistant().canFix(annotation);
            if (!isFixable) continue;
            IQuickAssistProcessor processor = this.sourceViewer.getQuickAssistAssistant().getQuickAssistProcessor();
            IQuickAssistInvocationContext context = this.sourceViewer.getQuickAssistInvocationContext();
            ICompletionProposal[] iCompletionProposalArray = proposals = processor.computeQuickAssistProposals(context);
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal proposal = iCompletionProposalArray[n2];
                quickFixMenu.add(this.createQuickFixAction(proposal));
                ++n2;
            }
        }
    }

    private boolean includes(Position position, int caretOffset) {
        return position != null && (position.includes(caretOffset) || position.offset + position.length == caretOffset);
    }

    private IAction createQuickFixAction(final ICompletionProposal proposal) {
        return new Action(proposal.getDisplayString()){

            public void run() {
                proposal.apply(SpellcheckableMessageArea.this.sourceViewer.getDocument());
            }

            public ImageDescriptor getImageDescriptor() {
                Image image = proposal.getImage();
                if (image != null) {
                    return ImageDescriptor.createFromImage((Image)image);
                }
                return null;
            }
        };
    }

    protected IHandlerService getHandlerService() {
        return (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
    }

    private SourceViewerDecorationSupport configureAnnotationPreferences() {
        ISharedTextColors textColors = EditorsUI.getSharedTextColors();
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)this.sourceViewer, null, (IAnnotationAccess)annotationAccess, textColors);
        List annotationPreferences = new MarkerAnnotationPreferences().getAnnotationPreferences();
        annotationPreferences.iterator().forEachRemaining(arg_0 -> ((SourceViewerDecorationSupport)support).setAnnotationPreference(arg_0));
        support.install(EditorsUI.getPreferenceStore());
        return support;
    }

    protected void createMarginPainter() {
        MarginPainter marginPainter = new MarginPainter((ITextViewer)this.sourceViewer);
        marginPainter.setMarginRulerColumn(72);
        marginPainter.setMarginRulerColor(PlatformUI.getWorkbench().getDisplay().getSystemColor(15));
        this.sourceViewer.addPainter((IPainter)marginPainter);
    }

    private double getCharWidth() {
        GC gc = new GC((Drawable)this.getTextWidget());
        double charWidth = gc.getFontMetrics().getAverageCharacterWidth();
        gc.dispose();
        return charWidth;
    }

    private int getLineHeight() {
        return this.getTextWidget().getLineHeight();
    }

    private static boolean shouldHardWrap() {
        return Activator.getDefault().getPreferenceStore().getBoolean("commit_dialog_hard_wrap_message");
    }

    public void addCleanupChangeListener(Runnable listener) {
        this.cleanupChangeListeners.addIfAbsent(listener);
    }

    public void removeCleanupChangeListener(Runnable listener) {
        this.cleanupChangeListeners.remove(listener);
    }

    public StyledText getTextWidget() {
        return this.sourceViewer.getTextWidget();
    }

    private IAction createContentAssistAction(final SourceViewer viewer) {
        Action proposalAction = new Action(){

            public void run() {
                viewer.doOperation(13);
            }
        };
        proposalAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        return proposalAction;
    }

    public String getCommitMessage() {
        String text = this.getText();
        if ((text = Utils.normalizeLineEndings((String)text)) == null) {
            return "";
        }
        text = CommitConfig.cleanText((String)text, (CommitConfig.CleanupMode)this.cleanupMode, (char)this.commentChar);
        if (SpellcheckableMessageArea.shouldHardWrap()) {
            text = SpellcheckableMessageArea.wrapCommitMessage(text, this.commentChar);
        }
        text = TRAILING_WHITE_SPACE_ON_LINES.matcher(text).replaceAll("");
        text = TRAILING_NEWLINES.matcher(text).replaceFirst("\n");
        return text;
    }

    protected static String wrapCommitMessage(String text, char commentChar) {
        int footerStart = CommonUtils.getFooterOffset(text);
        if (footerStart < 0) {
            return SpellcheckableMessageArea.hardWrap(text, commentChar);
        }
        String footer = text.substring(footerStart);
        text = SpellcheckableMessageArea.hardWrap(text.substring(0, footerStart), commentChar);
        return String.valueOf(text) + footer;
    }

    protected static String hardWrap(String text, char commentChar) {
        int[] wrapOffsets = SpellcheckableMessageArea.calculateWrapOffsets(text, 72, commentChar);
        if (wrapOffsets != null) {
            StringBuilder builder = new StringBuilder(text.length() + wrapOffsets.length);
            int prev = 0;
            int[] nArray = wrapOffsets;
            int n = wrapOffsets.length;
            int n2 = 0;
            while (n2 < n) {
                int cur = nArray[n2];
                builder.append(text.substring(prev, cur));
                int j = cur;
                while (j > prev && builder.charAt(builder.length() - 1) == ' ') {
                    builder.deleteCharAt(builder.length() - 1);
                    --j;
                }
                builder.append('\n');
                prev = cur;
                ++n2;
            }
            builder.append(text.substring(prev));
            return builder.toString();
        }
        return text;
    }

    protected Map<String, IAdaptable> getHyperlinkTargets() {
        return Collections.singletonMap("org.eclipse.ui.DefaultTextEditor", this.getDefaultTarget());
    }

    protected IContentAssistant createContentAssistant(ISourceViewer viewer) {
        return null;
    }

    protected IAdaptable getDefaultTarget() {
        return null;
    }

    public String getText() {
        return this.getDocument().get();
    }

    public TextViewer getViewer() {
        return this.sourceViewer;
    }

    public IDocument getDocument() {
        return this.sourceViewer.getDocument();
    }

    public void setText(String text) {
        if (text != null) {
            this.getDocument().set(text);
        }
    }

    @NonNull
    public CommitConfig.CleanupMode getCleanupMode() {
        return this.cleanupMode;
    }

    public char getCommentChar() {
        return this.commentChar;
    }

    public void setCleanupMode(@NonNull CommitConfig.CleanupMode mode, char commentChar) {
        if (CommitConfig.CleanupMode.DEFAULT.equals((Object)mode)) {
            throw new IllegalArgumentException("Clean-up mode must not be " + mode);
        }
        boolean changed = this.cleanupMode != mode || this.commentChar != commentChar;
        this.cleanupMode = mode;
        this.commentChar = commentChar;
        if (changed) {
            this.cleanupChangeListeners.forEach(Runnable::run);
        }
    }

    public void invalidatePresentation() {
        this.sourceViewer.invalidateTextPresentation();
        IDocument document = this.getDocument();
        TextUtilities.addDocumentPartitioners((IDocument)document, (Map)TextUtilities.removeDocumentPartitioners((IDocument)document));
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        StyledText textWidget = this.getTextWidget();
        textWidget.setBackground(color);
    }

    public boolean forceFocus() {
        StyledText text = this.getTextWidget();
        if (text == null || text.isDisposed()) {
            return false;
        }
        return text.setFocus();
    }

    public static int[] calculateWrapOffsets(String line, int maxLineLength, char commentChar) {
        if (line.length() == 0) {
            return null;
        }
        IntList wrapOffsets = new IntList();
        int wordStart = 0;
        int lineStart = 0;
        int length = line.length();
        int nofPreviousWordChars = 0;
        int nofCurrentWordChars = 0;
        int i = 0;
        while (i < length) {
            char ch = line.charAt(i);
            if (ch == ' ') {
                nofPreviousWordChars += nofCurrentWordChars;
                nofCurrentWordChars = 0;
            } else if (ch == '\n') {
                lineStart = i + 1;
                wordStart = i + 1;
                nofPreviousWordChars = 0;
                nofCurrentWordChars = 0;
            } else {
                if (nofCurrentWordChars == 0 && ch != commentChar && (nofPreviousWordChars > maxLineLength / 10 || nofPreviousWordChars > 0 && i - lineStart > maxLineLength / 2)) {
                    wordStart = i;
                }
                ++nofCurrentWordChars;
                if (i >= lineStart + maxLineLength && wordStart != lineStart) {
                    wrapOffsets.add(wordStart);
                    lineStart = wordStart;
                    nofPreviousWordChars = 0;
                    nofCurrentWordChars = 0;
                }
            }
            ++i;
        }
        int size = wrapOffsets.size();
        if (size == 0) {
            return null;
        }
        int[] result = new int[size];
        int i2 = 0;
        while (i2 < size) {
            result[i2] = wrapOffsets.get(i2);
            ++i2;
        }
        return result;
    }

    @FunctionalInterface
    private static interface CharSupplier {
        public char get();
    }

    private static class CommitPartitionTokenScanner
    implements IPartitionTokenScanner {
        private static final String CUT = " ------------------------ >8 ------------------------";
        private static final IToken COMMENT = new Token((Object)"_egit_commit_message_comment");
        private static final IToken DEFAULT = new Token(null);
        private final Supplier<CommitConfig.CleanupMode> cleanupMode;
        private final CharSupplier commentChar;
        private IDocument currentDoc;
        private int currentOffset;
        private int end;
        private int tokenStart;

        public CommitPartitionTokenScanner(CharSupplier commentChar, Supplier<CommitConfig.CleanupMode> mode) {
            this.commentChar = commentChar;
            this.cleanupMode = mode;
        }

        public void setRange(IDocument document, int offset, int length) {
            this.currentDoc = document;
            this.currentOffset = offset;
            this.end = offset + length;
            this.tokenStart = -1;
        }

        public IToken nextToken() {
            this.tokenStart = this.currentOffset;
            if (this.tokenStart >= this.end) {
                return Token.EOF;
            }
            CommitConfig.CleanupMode mode = this.cleanupMode.get();
            char commentCharacter = this.commentChar.get();
            if (CommitConfig.CleanupMode.SCISSORS.equals((Object)mode)) {
                int scissors = -1;
                int nOfLines = this.currentDoc.getNumberOfLines();
                try {
                    String cut = String.valueOf(commentCharacter) + CUT;
                    int i = 0;
                    while (i < nOfLines) {
                        IRegion info = this.currentDoc.getLineInformation(i);
                        String line = this.currentDoc.get(info.getOffset(), info.getLength());
                        if (line.equals(cut)) {
                            scissors = info.getOffset();
                            break;
                        }
                        ++i;
                    }
                }
                catch (BadLocationException cut) {
                    // empty catch block
                }
                if (scissors < 0) {
                    this.currentOffset = this.end;
                    return DEFAULT;
                }
                if (this.currentOffset < scissors) {
                    this.currentOffset = scissors;
                    return DEFAULT;
                }
                this.currentOffset = this.end;
                return COMMENT;
            }
            if (!CommitConfig.CleanupMode.STRIP.equals((Object)mode)) {
                this.currentOffset = this.end;
                return DEFAULT;
            }
            try {
                String line;
                IRegion info;
                int lineNumber;
                int nOfLines = this.currentDoc.getNumberOfLines();
                int initialLine = lineNumber = this.currentDoc.getLineOfOffset(this.currentOffset);
                IToken result = DEFAULT;
                while (lineNumber < nOfLines) {
                    info = this.currentDoc.getLineInformation(lineNumber);
                    line = this.currentDoc.get(info.getOffset(), info.getLength());
                    if (CommitPartitionTokenScanner.isComment(line, commentCharacter)) break;
                    ++lineNumber;
                }
                if (lineNumber == initialLine) {
                    ++lineNumber;
                    while (lineNumber < nOfLines) {
                        info = this.currentDoc.getLineInformation(lineNumber);
                        line = this.currentDoc.get(info.getOffset(), info.getLength());
                        if (!CommitPartitionTokenScanner.isComment(line, commentCharacter)) break;
                        ++lineNumber;
                    }
                    result = COMMENT;
                }
                this.currentOffset = lineNumber >= nOfLines ? this.end : this.currentDoc.getLineOffset(lineNumber);
                return result;
            }
            catch (BadLocationException e) {
                this.currentOffset = this.end;
                return DEFAULT;
            }
        }

        public int getTokenOffset() {
            return this.tokenStart;
        }

        public int getTokenLength() {
            return this.currentOffset - this.tokenStart;
        }

        public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
            this.setRange(document, offset, length);
        }

        private static boolean isComment(String text, char commentChar) {
            int len = text.length();
            int i = 0;
            while (i < len) {
                char ch = text.charAt(i);
                if (!Character.isWhitespace(ch)) {
                    return ch == commentChar;
                }
                ++i;
            }
            return false;
        }
    }

    private static class QuickfixAction
    extends Action {
        private final ITextOperationTarget textOperationTarget;

        public QuickfixAction(ITextOperationTarget target) {
            this.textOperationTarget = target;
            this.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        }

        public void run() {
            if (this.textOperationTarget.canDoOperation(22)) {
                this.textOperationTarget.doOperation(22);
            }
        }
    }
}

