/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.HttpURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UriCompliance
implements ComplianceViolation.Mode {
    private static final Logger LOG = LoggerFactory.getLogger(UriCompliance.class);
    public static final Set<Violation> NO_VIOLATION = Collections.unmodifiableSet(EnumSet.noneOf(Violation.class));
    public static final Set<Violation> AMBIGUOUS_VIOLATIONS = Collections.unmodifiableSet(EnumSet.of(Violation.AMBIGUOUS_EMPTY_SEGMENT, Violation.AMBIGUOUS_PATH_ENCODING, Violation.AMBIGUOUS_PATH_PARAMETER, Violation.AMBIGUOUS_PATH_SEGMENT, Violation.AMBIGUOUS_PATH_SEPARATOR));
    public static final UriCompliance RFC3986 = new UriCompliance("RFC3986", EnumSet.noneOf(Violation.class));
    public static final UriCompliance UNAMBIGUOUS = new UriCompliance("UNAMBIGUOUS", EnumSet.complementOf(EnumSet.copyOf(AMBIGUOUS_VIOLATIONS)));
    public static final UriCompliance DEFAULT = new UriCompliance("DEFAULT", RFC3986.getAllowed());
    public static final UriCompliance LEGACY = new UriCompliance("LEGACY", EnumSet.of(Violation.AMBIGUOUS_PATH_SEGMENT, new Violation[]{Violation.AMBIGUOUS_PATH_SEPARATOR, Violation.AMBIGUOUS_PATH_ENCODING, Violation.AMBIGUOUS_EMPTY_SEGMENT, Violation.UTF16_ENCODINGS, Violation.USER_INFO}));
    public static final UriCompliance UNSAFE = new UriCompliance("UNSAFE", EnumSet.allOf(Violation.class));
    private static final AtomicInteger __custom = new AtomicInteger();
    private static final List<UriCompliance> KNOWN_MODES = List.of(DEFAULT, LEGACY, RFC3986, UNAMBIGUOUS, UNSAFE);
    private final String _name;
    private final Set<Violation> _allowed;

    public static boolean isAmbiguous(Set<Violation> violations) {
        if (violations.isEmpty()) {
            return false;
        }
        for (Violation v : AMBIGUOUS_VIOLATIONS) {
            if (!violations.contains(v)) continue;
            return true;
        }
        return false;
    }

    public static UriCompliance valueOf(String name) {
        for (UriCompliance compliance : KNOWN_MODES) {
            if (!compliance.getName().equals(name)) continue;
            return compliance;
        }
        if (name.indexOf(44) == -1) {
            LOG.warn("Unknown UriCompliance mode {}", (Object)name);
        }
        return null;
    }

    public static UriCompliance from(Set<Violation> violations) {
        return new UriCompliance("CUSTOM" + __custom.getAndIncrement(), violations);
    }

    public static UriCompliance from(String spec) {
        UriCompliance compliance = UriCompliance.valueOf(spec);
        if (compliance == null) {
            String[] elements = spec.split("\\s*,\\s*");
            EnumSet<Violation> violations = switch (elements[0]) {
                case "0" -> EnumSet.noneOf(Violation.class);
                case "*" -> EnumSet.allOf(Violation.class);
                default -> {
                    UriCompliance mode = UriCompliance.valueOf(elements[0]);
                    if (mode == null) {
                        yield EnumSet.noneOf(Violation.class);
                    }
                    yield UriCompliance.copyOf(mode.getAllowed());
                }
            };
            for (int i = 1; i < elements.length; ++i) {
                String element = elements[i];
                boolean exclude = element.startsWith("-");
                if (exclude) {
                    element = element.substring(1);
                }
                Violation section = Violation.valueOf(element);
                if (exclude) {
                    violations.remove(section);
                    continue;
                }
                violations.add(section);
            }
            compliance = new UriCompliance("CUSTOM" + __custom.getAndIncrement(), violations);
        }
        return compliance;
    }

    public UriCompliance(String name, Set<Violation> violations) {
        Objects.requireNonNull(violations);
        this._name = name;
        this._allowed = violations.isEmpty() ? NO_VIOLATION : Collections.unmodifiableSet(UriCompliance.copyOf(violations));
    }

    @Override
    public boolean allows(ComplianceViolation violation) {
        return violation instanceof Violation && this._allowed.contains(violation);
    }

    @Override
    public String getName() {
        return this._name;
    }

    public Set<Violation> getAllowed() {
        return this._allowed;
    }

    public Set<Violation> getKnown() {
        return EnumSet.allOf(Violation.class);
    }

    public UriCompliance with(String name, Violation ... violations) {
        Set<Violation> union = this._allowed.isEmpty() ? EnumSet.noneOf(Violation.class) : UriCompliance.copyOf(this._allowed);
        union.addAll(UriCompliance.copyOf(violations));
        return new UriCompliance(name, union);
    }

    public UriCompliance without(String name, Violation ... violations) {
        Set<Violation> remainder = this._allowed.isEmpty() ? EnumSet.noneOf(Violation.class) : UriCompliance.copyOf(this._allowed);
        remainder.removeAll(UriCompliance.copyOf(violations));
        return new UriCompliance(name, remainder);
    }

    public String toString() {
        return String.format("%s%s", this._name, this._allowed);
    }

    private static Set<Violation> copyOf(Violation[] violations) {
        if (violations == null || violations.length == 0) {
            return EnumSet.noneOf(Violation.class);
        }
        return EnumSet.copyOf(Arrays.asList(violations));
    }

    private static Set<Violation> copyOf(Set<Violation> violations) {
        if (violations == null || violations.isEmpty()) {
            return EnumSet.noneOf(Violation.class);
        }
        return EnumSet.copyOf(violations);
    }

    public static String checkUriCompliance(UriCompliance compliance, HttpURI uri, ComplianceViolation.Listener listener) {
        if (uri.hasViolations()) {
            StringBuilder violations = null;
            for (Violation violation : uri.getViolations()) {
                if (compliance != null && compliance.allows(violation)) continue;
                if (listener != null) {
                    listener.onComplianceViolation(new ComplianceViolation.Event(compliance, violation, uri.toString()));
                }
                if (violations == null) {
                    violations = new StringBuilder();
                } else {
                    violations.append(", ");
                }
                violations.append(violation.getDescription());
            }
            if (violations != null) {
                return violations.toString();
            }
        }
        return null;
    }

    public static enum Violation implements ComplianceViolation
    {
        AMBIGUOUS_PATH_SEGMENT("https://tools.ietf.org/html/rfc3986#section-3.3", "Ambiguous URI path segment"),
        AMBIGUOUS_EMPTY_SEGMENT("https://tools.ietf.org/html/rfc3986#section-3.3", "Ambiguous URI empty segment"),
        AMBIGUOUS_PATH_SEPARATOR("https://tools.ietf.org/html/rfc3986#section-3.3", "Ambiguous URI path separator"),
        AMBIGUOUS_PATH_PARAMETER("https://tools.ietf.org/html/rfc3986#section-3.3", "Ambiguous URI path parameter"),
        AMBIGUOUS_PATH_ENCODING("https://tools.ietf.org/html/rfc3986#section-3.3", "Ambiguous URI path encoding"),
        UTF16_ENCODINGS("https://www.w3.org/International/iri-edit/draft-duerst-iri.html#anchor29", "UTF-16 encoding"),
        BAD_UTF8_ENCODING("https://datatracker.ietf.org/doc/html/rfc5987#section-3.2.1", "Bad UTF-8 encoding"),
        SUSPICIOUS_PATH_CHARACTERS("https://jakarta.ee/specifications/servlet/6.0/jakarta-servlet-spec-6.0.html#uri-path-canonicalization", "Suspicious Path Character"),
        ILLEGAL_PATH_CHARACTERS("https://datatracker.ietf.org/doc/html/rfc3986#section-3.3", "Illegal Path Character"),
        USER_INFO("https://datatracker.ietf.org/doc/html/rfc9110#name-deprecation-of-userinfo-in-", "Deprecated User Info");

        private final String _url;
        private final String _description;

        private Violation(String url, String description) {
            this._url = url;
            this._description = description;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String getURL() {
            return this._url;
        }

        @Override
        public String getDescription() {
            return this._description;
        }
    }
}

