/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.eclipse.build.ui.deploy;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.presentation.BuildCoreEditorPlugin;
import org.eclipse.egf.portfolio.eclipse.build.ui.deploy.DeployDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.PlatformUI;

public abstract class DeployAction
implements IActionDelegate2 {
    private static final String END_COMMENT = "-->";
    private static final String USER_DEPLOY_JOB_NAME = "<!--userDeployJobName=";
    private static final String USER_DEPLOY_SERVER_URL = "<!--userDeployServerUrl=";
    protected Collection<IFile> configFiles = new ArrayList<IFile>();

    public void init(IAction action) {
    }

    public void dispose() {
        this.configFiles.clear();
    }

    public void runWithEvent(IAction action, Event event) {
        this.run();
    }

    public void run(IAction action) {
        this.run();
    }

    protected void run() {
        Shell activeShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        StringBuilder resultBuilder = new StringBuilder();
        for (IFile configFile : this.configFiles) {
            StringBuilder actionLabelbuilder = new StringBuilder();
            actionLabelbuilder.append(this.getActionName());
            actionLabelbuilder.append(" ");
            actionLabelbuilder.append(configFile.getFullPath().toString());
            resultBuilder.append(actionLabelbuilder.toString());
            resultBuilder.append(" : ");
            String initialServerUrl = "http://serverUrl:80";
            String initialJobName = configFile.getParent().getName();
            try {
                String line;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(configFile.getContents()));
                while ((line = bufferedReader.readLine()) != null) {
                    int indexOf = line.indexOf(USER_DEPLOY_SERVER_URL);
                    int indexOf2 = line.indexOf(END_COMMENT);
                    if (indexOf > -1 && indexOf2 > indexOf) {
                        initialServerUrl = line.substring(indexOf + USER_DEPLOY_SERVER_URL.length(), indexOf2);
                    }
                    indexOf = line.indexOf(USER_DEPLOY_JOB_NAME);
                    indexOf2 = line.indexOf(END_COMMENT);
                    if (indexOf <= -1 || indexOf2 <= indexOf) continue;
                    initialJobName = line.substring(indexOf + USER_DEPLOY_JOB_NAME.length(), indexOf2);
                }
                bufferedReader.close();
            }
            catch (Exception bufferedReader) {
                // empty catch block
            }
            DeployDialog deployDialog = new DeployDialog(activeShell, actionLabelbuilder.toString(), initialServerUrl, initialJobName);
            if (deployDialog.open() == 0) {
                try {
                    this.doRun(deployDialog.getServerUrl(), deployDialog.getJobName(), configFile);
                    resultBuilder.append(deployDialog.getJobName());
                    resultBuilder.append(" @ ");
                    resultBuilder.append(deployDialog.getServerUrl());
                }
                catch (Exception e) {
                    BuildCoreEditorPlugin.INSTANCE.log(e);
                    resultBuilder.append(e.getClass().getName());
                    resultBuilder.append(" - ");
                    resultBuilder.append(e.getMessage());
                }
            } else {
                resultBuilder.append("canceled");
            }
            resultBuilder.append(System.getProperty("line.separator"));
        }
        MessageDialog.openInformation((Shell)activeShell, (String)"Result", (String)resultBuilder.toString());
    }

    protected abstract String getActionName();

    protected abstract void doRun(String var1, String var2, IFile var3) throws Exception;

    public void selectionChanged(IAction action, ISelection selection) {
        this.configFiles.clear();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object file = objectArray[n2];
                if (file instanceof IFile) {
                    this.configFiles.add((IFile)file);
                }
                ++n2;
            }
        }
    }
}

