/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.task.ui.contributions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.ui.contributor.MenuContributor;
import org.eclipse.egf.model.editor.EGFModelEditorPlugin;
import org.eclipse.egf.model.ftask.Task;
import org.eclipse.egf.task.EGFTaskPlugin;
import org.eclipse.egf.task.ui.EGFTaskUIPlugin;
import org.eclipse.egf.task.ui.l10n.EGFTaskUIMessages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class OpenTaskImplementationMenuContributor
extends MenuContributor {
    public static final String OPEN_TASK_IMPLEMENTATION_ACTION_ID = "open-task-implementation";
    private OpenTaskImplementationAction _openAction = new OpenTaskImplementationAction();

    public void menuAboutToShow(IMenuManager menuManager) {
        if (((IStructuredSelection)this._selection).size() == 1 && this._openAction.getTask() != null && EGFTaskPlugin.KIND_JAVA.equals(this._openAction.getKind())) {
            this._openAction.setText(this.getText());
            this._openAction.setEnabled(this._openAction.isEnabled());
            menuManager.insertBefore("open", (IAction)this._openAction);
        }
    }

    protected String getText() {
        return EGFTaskUIMessages.TaskImplementationMenuContributor_openAction_label;
    }

    public static class FindOperation
    implements IRunnableWithProgress {
        private String _fqn;
        private Resource _resource;
        private IType _type;

        public FindOperation(Resource resource, String fqn) {
            this._resource = resource;
            this._fqn = fqn;
        }

        public IType getType() {
            return this._type;
        }

        public URI getURI() {
            URIConverter converter;
            Resource resource = this._resource;
            if (resource == null) {
                return null;
            }
            URI uri = resource.getURI();
            if (uri != null && resource.getResourceSet() != null && (converter = resource.getResourceSet().getURIConverter()) != null) {
                uri = converter.normalize(uri);
            }
            return uri;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException {
            try {
                try {
                    URI uri = this.getURI();
                    if (uri.isPlatformResource()) {
                        String path = uri.toPlatformString(true);
                        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
                        IJavaProject project = JavaCore.create((IProject)resource.getProject());
                        this._type = project.findType(this._fqn, monitor);
                    } else {
                        IPlatformFcore fcore = EGFCorePlugin.getPlatformFcore((Resource)this._resource);
                        Bundle fcoreBundle = fcore.getPlatformBundle().getBundle();
                        if (fcoreBundle == null) {
                            throw new InvocationTargetException((Throwable)new CoreException(EGFTaskUIPlugin.getDefault().newStatus(4, NLS.bind((String)EGFTaskUIMessages.OpenTaskImplementationMenuContributor_unable_to_find_platform_fcore, (Object)this._resource.getURI()), null)));
                        }
                        Class clazz = fcoreBundle.loadClass(this._fqn);
                        if (clazz == null) {
                            throw new InvocationTargetException((Throwable)new CoreException(EGFTaskUIPlugin.getDefault().newStatus(4, NLS.bind((String)EGFTaskUIMessages.OpenTaskImplementationMenuContributor_unable_to_load_class, (Object)this._fqn), null)));
                        }
                        String id = fcore.getPlatformBundle().getPluginBase().getId();
                        if (!PDECore.getDefault().getSearchablePluginsManager().isInJavaSearch(id)) {
                            PDECore.getDefault().getSearchablePluginsManager().addToJavaSearch(new IPluginModelBase[]{fcore.getPlatformBundle().getPluginModelBase()});
                        }
                        TypeSearchRequestor requestor = new TypeSearchRequestor();
                        SearchEngine engine = new SearchEngine(null);
                        engine.searchAllTypeNames(clazz.getPackage().getName().toCharArray(), 0, clazz.getSimpleName().toCharArray(), 0, 10, SearchEngine.createWorkspaceScope(), (TypeNameMatchRequestor)requestor, 3, monitor);
                        this._type = requestor.getMatched();
                    }
                }
                catch (Throwable t) {
                    throw new InvocationTargetException((Throwable)new CoreException(EGFTaskUIPlugin.getDefault().newStatus(4, EGFTaskUIMessages.OpenTaskImplementationMenuContributor_error_message, t)));
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private class OpenTaskImplementationAction
    extends Action {
        public OpenTaskImplementationAction() {
            this.setId(OpenTaskImplementationMenuContributor.OPEN_TASK_IMPLEMENTATION_ACTION_ID);
        }

        protected Task getTask() {
            if (OpenTaskImplementationMenuContributor.this._selection == null) {
                return null;
            }
            IStructuredSelection sselection = (IStructuredSelection)OpenTaskImplementationMenuContributor.this._selection;
            if (sselection.size() != 1) {
                return null;
            }
            Object object = sselection.getFirstElement();
            if (object instanceof Task) {
                return (Task)object;
            }
            return null;
        }

        protected Resource getResource() {
            Task task = this.getTask();
            if (task == null) {
                return null;
            }
            return task.eResource();
        }

        protected String getKind() {
            Task task = this.getTask();
            if (task == null) {
                return null;
            }
            if (task.getKindValue() != null && task.getKindValue().trim().length() != 0) {
                return task.getKindValue().trim();
            }
            return null;
        }

        protected String getImplementation() {
            Task task = this.getTask();
            if (task == null) {
                return null;
            }
            if (task.getImplementationValue() != null && task.getImplementationValue().trim().length() != 0) {
                return task.getImplementationValue().trim();
            }
            return null;
        }

        public boolean isEnabled() {
            if (this.getTask() == null) {
                return false;
            }
            if (this.getTask().eResource() == null) {
                return false;
            }
            if (this.getKind() == null) {
                return false;
            }
            return this.getImplementation() != null && this.getImplementation().length() != 0;
        }

        public void run() {
            FindOperation operation = new FindOperation(this.getResource(), this.getImplementation());
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)operation);
                if (operation.getType() != null) {
                    JavaUI.openInEditor((IJavaElement)operation.getType());
                } else {
                    MessageDialog.openError((Shell)OpenTaskImplementationMenuContributor.this._activeEditorPart.getSite().getShell(), (String)EGFTaskUIMessages.OpenTaskImplementationMenuContributor_error_title, (String)NLS.bind((String)EGFTaskUIMessages.OpenTaskImplementationMenuContributor_error_message, (Object)this.getImplementation()));
                }
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Throwable t) {
                ThrowableHandler.handleThrowable((String)EGFModelEditorPlugin.getPlugin().getSymbolicName(), (Throwable)t);
                return;
            }
        }
    }

    private static class TypeSearchRequestor
    extends TypeNameMatchRequestor {
        private IType _matched;

        public void acceptTypeNameMatch(TypeNameMatch match) {
            this._matched = match.getType();
        }

        public IType getMatched() {
            return this._matched;
        }
    }
}

