/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.templateEditor.computer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternVariable;
import org.eclipse.egf.pattern.ui.ImageShop;
import org.eclipse.egf.pattern.ui.editors.templateEditor.TemplateEditorUtility;
import org.eclipse.egf.pattern.ui.editors.templateEditor.computer.AbstractProposalComputer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternVariableProposalComputer
extends AbstractProposalComputer {
    private ITextViewer viewer;
    private int offset;
    private Pattern pattern;

    public PatternVariableProposalComputer(ITextViewer viewer, int offset, Pattern pattern) {
        this.viewer = viewer;
        this.offset = offset;
        this.pattern = pattern;
    }

    @Override
    public List<ICompletionProposal> computeProposal() {
        String[] allWords = TemplateEditorUtility.getAllWords(this.viewer, this.offset);
        ArrayList<ICompletionProposal> variableProposals = new ArrayList<ICompletionProposal>();
        if (allWords.length > 0) {
            String replacedWord = allWords[0];
            int replacementOffset = this.offset - replacedWord.length();
            EList allVariables = this.pattern.getAllVariables();
            for (PatternVariable variable : allVariables) {
                String variableName = variable.getName();
                String displayName = String.valueOf(variableName) + " - " + PatternVariableProposalComputer.getType(variable.getType());
                if ("".equals(replacedWord) || variableName.indexOf(replacedWord) != 0) continue;
                JavaCompletionProposal propsal = new JavaCompletionProposal(variableName, replacementOffset, replacedWord.length(), ImageShop.get("/icons/variable_obj.gif"), displayName, variableName.length());
                variableProposals.add((ICompletionProposal)propsal);
            }
        }
        return variableProposals;
    }
}

