/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table.provider;

import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.ActionConstants;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.ChangeMessageInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.process.ReplyProcess;
import org.eclipse.egerrit.internal.ui.table.filter.AuthorKindFilter;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;

public class HistoryTableMenuBuilder {
    private Menu commonMenu;
    private FilterSelectionAction humanOnlyfilter = null;
    private FilterSelectionAction machineOnlyfilter = null;
    private ReplyMessageAction replyMessages = null;

    public void addPulldownMenu(ColumnViewer viewer, GerritClient client) {
        MenuManager menuManager = new MenuManager();
        if (viewer instanceof TableViewer) {
            this.commonMenu = menuManager.createContextMenu((Control)((TableViewer)viewer).getTable());
            ((TableViewer)viewer).getTable().setMenu(this.commonMenu);
            this.humanOnlyfilter = new FilterSelectionAction(Messages.UIHistoryTable_0, (StructuredViewer)viewer, new AuthorKindFilter(false));
            this.machineOnlyfilter = new FilterSelectionAction(Messages.UIHistoryTable_1, (StructuredViewer)viewer, new AuthorKindFilter(true));
            this.replyMessages = new ReplyMessageAction(ActionConstants.REPLY.getLiteral(), (StructuredViewer)viewer, client);
        }
        menuManager.addMenuListener(manager -> this.addMenuItem(this.commonMenu, viewer));
        menuManager.update(true);
    }

    private void addMenuItem(Menu menu, ColumnViewer viewer) {
        if (menu.getItemCount() == 0 && viewer instanceof TableViewer) {
            MenuManager menuMgr = new MenuManager();
            menuMgr.add((IAction)this.replyMessages);
            menuMgr.add((IContributionItem)new Separator());
            menuMgr.add((IAction)this.humanOnlyfilter);
            menuMgr.add((IAction)this.machineOnlyfilter);
            menuMgr.createContextMenu((Control)menu.getShell()).setVisible(true);
            menuMgr.add((IContributionItem)new Separator());
            menuMgr.add((IAction)new Action(Messages.UIHistoryTable_reset){

                public void run() {
                    HistoryTableMenuBuilder.this.humanOnlyfilter.setChecked(false);
                    HistoryTableMenuBuilder.this.humanOnlyfilter.run();
                    HistoryTableMenuBuilder.this.machineOnlyfilter.setChecked(false);
                    HistoryTableMenuBuilder.this.machineOnlyfilter.run();
                }
            });
        }
    }

    private class FilterSelectionAction
    extends Action {
        private ViewerFilter filterInstance;
        private StructuredViewer viewer;

        public FilterSelectionAction(String actionName, StructuredViewer viewer, AuthorKindFilter humanOnlyfilter) {
            super(actionName, 2);
            this.viewer = viewer;
            this.filterInstance = humanOnlyfilter;
        }

        public void run() {
            if (this.isChecked()) {
                this.viewer.addFilter(this.filterInstance);
            } else {
                this.viewer.removeFilter(this.filterInstance);
            }
        }
    }

    private class ReplyMessageAction
    extends Action {
        private StructuredViewer viewer;
        private GerritClient gerritClient;

        public ReplyMessageAction(String actionName, StructuredViewer viewer, GerritClient client) {
            super(actionName, 1);
            this.viewer = viewer;
            this.gerritClient = client;
        }

        public void run() {
            IStructuredSelection struct;
            Object obj;
            ISelection selection = this.viewer.getSelection();
            if (!selection.isEmpty() && selection instanceof StructuredSelection && (obj = (struct = (IStructuredSelection)selection).getFirstElement()) instanceof ChangeMessageInfo) {
                ChangeMessageInfo messageInfo = (ChangeMessageInfo)obj;
                ReplyProcess replyProcess = new ReplyProcess();
                ChangeInfo changeInfo = (ChangeInfo)messageInfo.eContainer();
                RevisionInfo revisionInfo = changeInfo.getRevisionByNumber(messageInfo.get_revision_number());
                replyProcess.handleReplyDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), changeInfo, this.gerritClient, revisionInfo, messageInfo);
            }
        }
    }
}

