/**
 *   Copyright (c) 2015 Ericsson AB
 *  
 *   All rights reserved. This program and the accompanying materials are
 *   made available under the terms of the Eclipse Public License v1.0 which
 *   accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     Ericsson AB - Initial API and implementation
 */
package org.eclipse.egerrit.internal.model;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Change Message Info</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.egerrit.internal.model.ChangeMessageInfo#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.egerrit.internal.model.ChangeMessageInfo#getAuthor <em>Author</em>}</li>
 *   <li>{@link org.eclipse.egerrit.internal.model.ChangeMessageInfo#getDate <em>Date</em>}</li>
 *   <li>{@link org.eclipse.egerrit.internal.model.ChangeMessageInfo#getMessage <em>Message</em>}</li>
 *   <li>{@link org.eclipse.egerrit.internal.model.ChangeMessageInfo#get_revision_number <em>revision number</em>}</li>
 *   <li>{@link org.eclipse.egerrit.internal.model.ChangeMessageInfo#isComment <em>Comment</em>}</li>
 * </ul>
 *
 * @see org.eclipse.egerrit.internal.model.ModelPackage#getChangeMessageInfo()
 * @model
 * @generated
 */
public interface ChangeMessageInfo extends EObject {
	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.eclipse.egerrit.internal.model.ModelPackage#getChangeMessageInfo_Id()
	 * @model
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.eclipse.egerrit.internal.model.ChangeMessageInfo#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Author</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Author</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Author</em>' containment reference.
	 * @see #setAuthor(AccountInfo)
	 * @see org.eclipse.egerrit.internal.model.ModelPackage#getChangeMessageInfo_Author()
	 * @model containment="true"
	 * @generated
	 */
	AccountInfo getAuthor();

	/**
	 * Sets the value of the '{@link org.eclipse.egerrit.internal.model.ChangeMessageInfo#getAuthor <em>Author</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Author</em>' containment reference.
	 * @see #getAuthor()
	 * @generated
	 */
	void setAuthor(AccountInfo value);

	/**
	 * Returns the value of the '<em><b>Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Date</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Date</em>' attribute.
	 * @see #setDate(String)
	 * @see org.eclipse.egerrit.internal.model.ModelPackage#getChangeMessageInfo_Date()
	 * @model
	 * @generated
	 */
	String getDate();

	/**
	 * Sets the value of the '{@link org.eclipse.egerrit.internal.model.ChangeMessageInfo#getDate <em>Date</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Date</em>' attribute.
	 * @see #getDate()
	 * @generated
	 */
	void setDate(String value);

	/**
	 * Returns the value of the '<em><b>Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Message</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Message</em>' attribute.
	 * @see #setMessage(String)
	 * @see org.eclipse.egerrit.internal.model.ModelPackage#getChangeMessageInfo_Message()
	 * @model
	 * @generated
	 */
	String getMessage();

	/**
	 * Sets the value of the '{@link org.eclipse.egerrit.internal.model.ChangeMessageInfo#getMessage <em>Message</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Message</em>' attribute.
	 * @see #getMessage()
	 * @generated
	 */
	void setMessage(String value);

	/**
	 * Returns the value of the '<em><b>revision number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>revision number</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>revision number</em>' attribute.
	 * @see #set_revision_number(int)
	 * @see org.eclipse.egerrit.internal.model.ModelPackage#getChangeMessageInfo__revision_number()
	 * @model
	 * @generated
	 */
	int get_revision_number();

	/**
	 * Sets the value of the '{@link org.eclipse.egerrit.internal.model.ChangeMessageInfo#get_revision_number <em>revision number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>revision number</em>' attribute.
	 * @see #get_revision_number()
	 * @generated
	 */
	void set_revision_number(int value);

	/**
	 * Returns the value of the '<em><b>Comment</b></em>' attribute.
	 * The default value is <code>"false"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Comment</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Comment</em>' attribute.
	 * @see #setComment(boolean)
	 * @see org.eclipse.egerrit.internal.model.ModelPackage#getChangeMessageInfo_Comment()
	 * @model default="false"
	 * @generated
	 */
	boolean isComment();

	/**
	 * Sets the value of the '{@link org.eclipse.egerrit.internal.model.ChangeMessageInfo#isComment <em>Comment</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Comment</em>' attribute.
	 * @see #isComment()
	 * @generated
	 */
	void setComment(boolean value);

} // ChangeMessageInfo
