/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.editors.BranchSelectionDialog;
import org.eclipse.egerrit.internal.ui.editors.FindLocalRepository;
import org.eclipse.egerrit.internal.ui.table.model.BranchMatch;
import org.eclipse.egerrit.internal.ui.utils.ActiveWorkspaceRevision;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egit.ui.internal.dialogs.CheckoutConflictDialog;
import org.eclipse.egit.ui.internal.fetch.FetchGerritChangeWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CheckoutRevision
extends Action {
    private RevisionInfo revisionCheckedOut;
    private GerritClient gerritClient;
    private ChangeInfo changeInfo;

    public CheckoutRevision(RevisionInfo revision, GerritClient gerritClient) {
        this.revisionCheckedOut = revision;
        this.gerritClient = gerritClient;
        this.changeInfo = this.revisionCheckedOut.getChangeInfo();
        this.setText(Messages.CheckoutRevision_0);
    }

    public void run() {
        Map<String, BranchMatch> potentialBranches;
        Repository localRepo = new FindLocalRepository(this.gerritClient, this.changeInfo.getProject()).getRepository();
        if (localRepo == null) {
            Status status = new Status(4, "org.eclipse.egerrit.core", Messages.CheckoutRevision_1);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.CheckoutRevision_2, (String)Messages.CheckoutRevision_3, (IStatus)status);
            return;
        }
        String psSelected = this.revisionCheckedOut.getRef();
        if (psSelected == null || psSelected.isEmpty()) {
            Status status = new Status(4, "org.eclipse.egerrit.core", Messages.CheckoutRevision_4);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.CheckoutRevision_2, (String)Messages.CheckoutRevision_3, (IStatus)status);
        }
        if ((potentialBranches = this.findAllPotentialBranches(localRepo)).size() > 1) {
            this.branchUiSelection(localRepo, potentialBranches);
        } else if (potentialBranches.isEmpty()) {
            FetchGerritChangeWizard var = new FetchGerritChangeWizard(localRepo, psSelected);
            WizardDialog w = new WizardDialog(this.getShell(), (IWizard)var);
            w.create();
            w.open();
        } else if (!potentialBranches.entrySet().iterator().next().getValue().equals((Object)BranchMatch.PERFECT_MATCH)) {
            this.branchUiSelection(localRepo, potentialBranches);
        } else {
            String branchToCheckout = potentialBranches.keySet().iterator().next();
            try {
                this.checkoutBranch(branchToCheckout, localRepo);
            }
            catch (Exception exception) {}
        }
        ActiveWorkspaceRevision.getInstance().activateCurrentRevision(this.gerritClient, this.revisionCheckedOut);
    }

    public Map<String, BranchMatch> findAllPotentialBranches(Repository localRepo) {
        Git gitRepo = new Git(localRepo);
        String changeIdKey = "Change-Id";
        HashMap<String, String> mapBranches = new HashMap<String, String>();
        Map<String, BranchMatch> potentialBranches = null;
        HashMap<String, Map<String, List<String>>> mapBranchesChangeId = new HashMap<String, Map<String, List<String>>>();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (RevWalk walk = new RevWalk(localRepo);){
                this.mapBranchNameWithCommitId(gitRepo, changeIdKey, mapBranches, mapBranchesChangeId, walk);
                potentialBranches = this.mapPotentialBranch(mapBranchesChangeId);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GitAPIException e) {
            EGerritCorePlugin.logError((String)("find All Potential Branches()" + e.getMessage()));
        }
        gitRepo.close();
        return potentialBranches;
    }

    private void mapBranchNameWithCommitId(Git gitRepo, String changeIdKey, Map<String, String> mapBranches, Map<String, Map<String, List<String>>> mapBranchesChangeId, RevWalk walk) throws GitAPIException {
        for (Ref current : gitRepo.branchList().call()) {
            try {
                RevCommit commit = walk.parseCommit((AnyObjectId)current.getObjectId());
                mapBranches.put(Repository.shortenRefName((String)current.getName()), commit.getName());
                HashMap<String, List> mapCommitChangeid = new HashMap<String, List>();
                List footerLines = commit.getFooterLines(changeIdKey);
                mapCommitChangeid.put(commit.getName(), footerLines);
                mapBranchesChangeId.put(Repository.shortenRefName((String)current.getName()), mapCommitChangeid);
            }
            catch (IOException e) {
                EGerritCorePlugin.logError((String)(String.valueOf(this.gerritClient.getRepository().formatGerritVersion()) + e.getMessage()));
            }
        }
    }

    private void branchUiSelection(Repository localRepo, Map<String, BranchMatch> potentialBranches) {
        BranchSelectionDialog branchSelectDialog = new BranchSelectionDialog(null, potentialBranches, this.changeInfo, this.revisionCheckedOut);
        int result = branchSelectDialog.open();
        String selectedBranch = branchSelectDialog.getSelectedBranch();
        if (result == 0) {
            String psSelected = this.revisionCheckedOut.getRef();
            FetchGerritChangeWizard var = new FetchGerritChangeWizard(localRepo, psSelected);
            WizardDialog w = new WizardDialog(this.getShell(), (IWizard)var);
            w.create();
            w.open();
        } else if (result == 1024) {
            try {
                if (selectedBranch != null) {
                    this.checkoutBranch(selectedBranch, localRepo);
                }
            }
            catch (Exception exception) {}
        }
    }

    private Map<String, BranchMatch> mapPotentialBranch(Map<String, Map<String, List<String>>> mapBranchesChangeId) {
        String lookingChangeId = this.revisionCheckedOut.getChangeInfo().getChange_id().trim();
        String lookingCommitIdForRevision = this.revisionCheckedOut.getCommit().getCommit().trim();
        TreeMap<String, BranchMatch> mapBranches = new TreeMap<String, BranchMatch>();
        String defaultBranchName = String.valueOf(this.changeInfo.get_number()) + "/" + this.revisionCheckedOut.get_number();
        for (Map.Entry<String, Map<String, List<String>>> entryBranch : mapBranchesChangeId.entrySet()) {
            Map<String, List<String>> mapCommitId = entryBranch.getValue();
            for (Map.Entry<String, List<String>> entryCommitIds : mapCommitId.entrySet()) {
                List<String> listChangeIds = entryCommitIds.getValue();
                Iterator<String> iterChangeId = listChangeIds.iterator();
                while (iterChangeId.hasNext()) {
                    String changeId = iterChangeId.next().trim();
                    if (lookingCommitIdForRevision.equals(entryCommitIds.getKey())) {
                        mapBranches.put(entryBranch.getKey(), BranchMatch.PERFECT_MATCH);
                        continue;
                    }
                    if (lookingChangeId.equals(changeId)) {
                        mapBranches.put(entryBranch.getKey(), BranchMatch.CHANGE_ID_MATCH);
                        continue;
                    }
                    if (!entryBranch.getKey().contains(defaultBranchName)) continue;
                    mapBranches.put(entryBranch.getKey(), BranchMatch.BRANCH_NAME_MATCH);
                }
            }
        }
        return mapBranches;
    }

    public void checkoutBranch(String branchName, Repository repo) throws Exception {
        CheckoutCommand command = null;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Git gitRepo = new Git(repo);){
                command = gitRepo.checkout();
                command.setCreateBranch(false);
                command.setName(branchName);
                command.setForce(false);
                command.call();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            CheckoutResult result = command.getResult();
            new CheckoutConflictDialog(Display.getDefault().getActiveShell(), repo, result.getConflictList()).open();
        }
    }

    private Shell getShell() {
        return Display.getDefault().getActiveShell();
    }
}

