/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.core;

import com.google.gson.annotations.Expose;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

public class GerritServerInformation {
    private static final int DEFAULT_PORT = 29418;
    private static final String DEFAULT_SCHEME = "http";
    @Expose
    private String fServerURI;
    @Expose
    private String fServerScheme;
    @Expose
    private String fHostId;
    @Expose
    private String fServerPath;
    @Expose
    private String fServerName;
    @Expose
    private int fServerPort = 29418;
    @Expose
    private String fUserName;
    @Expose
    private boolean fPasswordProvided = false;
    private boolean fPasswordChanged = false;
    private String fPassword;
    private static final String KEY_PASSWORD = "password";
    private boolean fSelfSigned = false;

    public GerritServerInformation(String serverURI, String serverName) throws URISyntaxException {
        URI uri = null;
        uri = serverURI != null ? new URI(serverURI) : new URI("");
        if (uri != null) {
            this.setSeverInfo(uri);
        }
        this.setServerURI(serverURI);
        this.setServerName(serverName != null ? serverName.trim() : "");
    }

    public void setServerURI(String serverURI) {
        this.fServerURI = serverURI != null ? serverURI.trim() : "";
        this.fServerURI = this.removeTrailingSlash(this.fServerURI);
    }

    private String removeTrailingSlash(String server) {
        if (server != null && server.endsWith("/")) {
            return server.substring(0, server.length() - 1);
        }
        return server;
    }

    public GerritServerInformation getServerInfo() {
        return this;
    }

    public int getDefaultPort() {
        return 29418;
    }

    public String getScheme() {
        return this.fServerScheme != null ? this.fServerScheme : DEFAULT_SCHEME;
    }

    public String getHostId() {
        return this.fHostId != null ? this.fHostId : "";
    }

    public String getPath() {
        return this.fServerPath != null ? this.fServerPath : "";
    }

    public String getName() {
        return this.fServerName != null ? this.fServerName : "";
    }

    public String getServerURI() {
        return this.fServerURI != null ? this.fServerURI : "";
    }

    public int getPort() {
        return this.fServerPort;
    }

    public void setScheme(String text) {
        this.fServerScheme = text;
        if (this.fServerScheme != null) {
            this.getURI();
        }
    }

    public void setHostId(String serverId) {
        this.fHostId = serverId != null ? serverId.trim() : "";
        this.getURI();
    }

    public void setPort(int port) {
        this.fServerPort = port;
        this.getURI();
    }

    public void setPath(String text) {
        this.fServerPath = text;
        this.getURI();
    }

    public void setServerName(String text) {
        this.fServerName = text;
    }

    public void setUserName(String userName) {
        this.fUserName = userName != null ? userName.trim() : "";
    }

    public void setPassword(String password) {
        String string = this.fPassword = password != null ? password.trim() : "";
        if (this.fPassword.length() > 0) {
            this.fPasswordProvided = true;
            this.fPasswordChanged = true;
        }
    }

    public String getUserName() {
        return this.fUserName != null ? this.fUserName : "";
    }

    public void setSeverInfo(URI uri) {
        this.setScheme(uri.getScheme());
        this.setHostId(uri.getHost());
        this.setPort(uri.getPort());
        this.setPath(this.removeTrailingSlash(uri.getPath()));
        if (uri.getUserInfo() != null && this.getUserName().isEmpty()) {
            this.setUserName(uri.getUserInfo());
        }
    }

    public void setSelfSigned(boolean signed) {
        this.fSelfSigned = signed;
    }

    public boolean getSelfSigned() {
        return this.fSelfSigned;
    }

    private URI getURI() {
        try {
            URI uri = new URIBuilder().setScheme(this.getScheme()).setHost(this.getHostId()).setPort(this.getPort()).setPath(this.getPath()).build();
            if (uri.getHost() != null) {
                this.setServerURI(uri.toString());
                return uri;
            }
            return null;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public boolean isValid() throws URISyntaxException {
        URI uri = new URI(this.getServerURI());
        return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).equals(uri);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fServerName == null ? 0 : this.fServerName.hashCode());
        result = 31 * result + (this.fServerURI == null ? 0 : this.fServerURI.hashCode());
        result = 31 * result + (this.fUserName == null ? 0 : this.fUserName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GerritServerInformation other = (GerritServerInformation)obj;
        if (this.fServerName == null ? other.fServerName != null : !this.fServerName.equals(other.fServerName)) {
            return false;
        }
        if (this.fServerURI == null ? other.fServerURI != null : !this.fServerURI.equals(other.fServerURI)) {
            return false;
        }
        return !(this.fUserName == null ? other.fUserName != null : !this.fUserName.equals(other.fUserName));
    }

    public String getPassword() {
        if (this.getUserName().isEmpty()) {
            return null;
        }
        if (!this.isPasswordProvided()) {
            return null;
        }
        if (!this.internalGetPassword().isEmpty()) {
            return this.internalGetPassword();
        }
        ISecurePreferences securePref = SecurePreferencesFactory.getDefault();
        ISecurePreferences serverPreference = securePref.node(EncodingUtils.encodeSlashes((String)this.getPreferenceKey()));
        try {
            return serverPreference.get(KEY_PASSWORD, this.internalGetPassword());
        }
        catch (StorageException storageException) {
            return null;
        }
    }

    String internalGetPassword() {
        return this.fPassword != null ? this.fPassword : "";
    }

    void persistPassword() {
        if (!this.isPasswordProvided() || !this.fPasswordChanged) {
            return;
        }
        ISecurePreferences securePref = SecurePreferencesFactory.getDefault();
        ISecurePreferences serverPreference = securePref.node(EncodingUtils.encodeSlashes((String)this.getPreferenceKey()));
        try {
            serverPreference.put(KEY_PASSWORD, this.getPassword(), true);
            serverPreference.flush();
            this.fPasswordChanged = false;
        }
        catch (StorageException e) {
            EGerritCorePlugin.logError(e.getMessage());
        }
        catch (IOException e) {
            EGerritCorePlugin.logError(e.getMessage());
        }
    }

    private String getPreferenceKey() {
        return "org.eclipse.egerrit.core/" + this.getServerURI() + this.getName();
    }

    public boolean isPasswordProvided() {
        return this.fPasswordProvided;
    }

    public boolean isPasswordChanged() {
        return this.fPasswordChanged;
    }

    public boolean isAnonymous() {
        return this.fUserName == null || this.fUserName.length() == 0;
    }

    public GerritServerInformation clone() {
        try {
            GerritServerInformation clone = new GerritServerInformation(this.fServerURI, this.fServerName);
            clone.fServerURI = this.fServerURI;
            clone.fServerScheme = this.fServerScheme;
            clone.fHostId = this.fHostId;
            clone.fServerPath = this.fServerPath;
            clone.fServerName = this.fServerName;
            clone.fServerPort = this.fServerPort;
            clone.fUserName = this.fUserName;
            clone.fPasswordProvided = this.fPasswordProvided;
            clone.fPasswordChanged = this.fPasswordChanged;
            clone.fPassword = this.fPassword;
            clone.fSelfSigned = this.fSelfSigned;
            return clone;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException("Failed to clone " + this);
        }
    }
}

