/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.core.command;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.eclipse.egerrit.internal.model.ModelPackage;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMFTypeAdapterFactory
implements TypeAdapterFactory {
    private static final Logger logger = LoggerFactory.getLogger(EMFTypeAdapterFactory.class);

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        if (!EObject.class.isAssignableFrom(typeToken.getRawType())) {
            return null;
        }
        return new EObjectTypeAdapter(gson, typeToken.getType());
    }

    public static class EObjectTypeAdapter
    extends TypeAdapter<EObject> {
        private Type expectedType;
        private Gson gson;

        public EObjectTypeAdapter(Gson gson, Type expectedType) {
            this.expectedType = expectedType;
            this.gson = gson;
        }

        private EClass toEClass() {
            EClassifier classifier = ModelPackage.eINSTANCE.getEClassifier(this.expectedType.getTypeName().substring(this.expectedType.getTypeName().lastIndexOf(46) + 1));
            return (EClass)classifier;
        }

        private EStructuralFeature getAttributeWithName(EClass eclass, String name) {
            return eclass.getEStructuralFeature(name);
        }

        private TypeAdapter getTypeAdapter(EObject instance, EStructuralFeature feature) {
            if (!feature.isMany()) {
                return this.gson.getAdapter(feature.getEType().getInstanceClass());
            }
            if (EMap.class.isAssignableFrom(instance.eGet(feature).getClass())) {
                Class keyType = ((EReference)feature).getEReferenceType().getEStructuralFeature("key").getEType().getInstanceClass();
                EStructuralFeature valueFeature = ((EReference)feature).getEReferenceType().getEStructuralFeature("value");
                Type valueType = null;
                valueType = !valueFeature.isMany() ? valueFeature.getEType().getInstanceClass() : TypeToken.get((Type)new MapType((Type)((Object)BasicEList.class), new Type[]{valueFeature.getEType().getInstanceClass()})).getType();
                return this.gson.getAdapter(TypeToken.get((Type)new MapType((Type)((Object)Map.class), new Type[]{keyType, valueType})));
            }
            if (EList.class.isAssignableFrom(instance.eGet(feature).getClass())) {
                return this.gson.getAdapter(TypeToken.get((Type)new MapType((Type)((Object)List.class), new Type[]{feature.getEGenericType().getEClassifier().getInstanceClass()})));
            }
            return this.gson.getAdapter(instance.eGet(feature).getClass());
        }

        public EObject read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            EObject instance = EcoreUtil.create((EClass)this.toEClass());
            try {
                in.beginObject();
                while (in.hasNext()) {
                    String name = in.nextName();
                    EStructuralFeature feature = this.getAttributeWithName(instance.eClass(), name);
                    if (feature == null) {
                        in.skipValue();
                        continue;
                    }
                    Object value = this.getTypeAdapter(instance, feature).read(in);
                    instance.eSet(feature, value);
                }
            }
            catch (IllegalStateException e) {
                throw new JsonSyntaxException((Throwable)e);
            }
            in.endObject();
            return instance;
        }

        public void write(JsonWriter out, EObject value) throws IOException {
            new UnsupportedOperationException("Serialization is not supported");
        }
    }

    public static class MapType
    implements Type,
    ParameterizedType {
        private Type[] actualTypes;
        private Type rawType;

        public MapType(Type raw, Type[] actualTypes) {
            this.rawType = raw;
            this.actualTypes = actualTypes;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypes;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    }
}

