/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.di;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javafx.scene.image.Image;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.ui.di.ResourceProviderService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class BasicResourceProvider
implements ResourceProviderService {
    protected Map<String, String> properties;
    protected BundleContext context;
    protected Logger logger = LoggerCreator.createLogger(this.getClass());

    public void activate(BundleContext context, Map<String, String> properties) {
        this.properties = properties;
        this.context = context;
    }

    @Override
    public @Nullable Image getImage(@NonNull String key) throws IOException {
        URL url = FileLocator.find((Bundle)this.context.getBundle(), (IPath)new Path(this.properties.get(key)), null);
        if (url != null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream stream = url.openStream();){
                    return new Image(stream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.logger.error("Unabled to load image with key '" + key + "' at URL '" + String.valueOf(url) + "'", (Throwable)e);
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
        }
        if (this.logger.isEnabled(Logger.Level.INFO)) {
            this.logger.info("Unable to find image with key '" + key + "'");
        }
        return null;
    }
}

