/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.workbench.Selector;
import org.eclipse.fx.ui.workbench.renderers.base.BaseItemRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.EventProcessor;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;
import org.eclipse.jdt.annotation.NonNull;

public abstract class BaseItemContainerRenderer<M extends MElementContainer<I>, I extends MUIElement, W extends WWidget<M>>
extends BaseRenderer<M, W>
implements EventProcessor.ChildrenHandler<M, I> {
    private List<I> widgets = new ArrayList<I>();
    @Inject
    IEclipseContext context;

    @PostConstruct
    void init(IEventBroker eventBroker) {
        EventProcessor.attachChildProcessor(eventBroker, this);
        EventProcessor.attachVisibleProcessor(eventBroker, this);
        final Selector noop = m -> true;
        eventBroker.subscribe("org/eclipse/fx/context/key", e -> this.checkExecute(noop));
        eventBroker.subscribe("org/eclipse/e4/ui/renderer/requestEnablementUpdate", e -> {
            Object d = e.getProperty("org.eclipse.e4.data");
            if (d instanceof Selector) {
                this.checkExecute((Selector)d);
            } else if ("ALL".equals(d)) {
                this.checkExecute(noop);
            } else if (d != null) {
                this.checkExecute(m -> d.equals(m.getElementId()));
            }
        });
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/Dirtyable/dirty/*", e -> this.checkExecute(noop));
        this.context.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                context.get("activeContexts");
                context.get("org.eclipse.ui.selection");
                context.get("e4ActivePart");
                BaseItemContainerRenderer.this.checkExecute(noop);
                return true;
            }
        });
        this.do_init(eventBroker);
    }

    protected boolean skipEnablementCheck() {
        return false;
    }

    protected boolean isShowing(I item) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkExecute(Selector selector) {
        ArrayList<I> iterationCopy;
        if (this.skipEnablementCheck()) {
            return;
        }
        List<I> list = this.widgets;
        synchronized (list) {
            iterationCopy = new ArrayList<I>(this.widgets);
        }
        for (MUIElement e : iterationCopy) {
            if (!this.isShowing(e) || !(e instanceof MItem) || !(e.getRenderer() instanceof BaseItemRenderer) || !selector.select((MApplicationElement)e)) continue;
            MItem tmp = (MItem)e;
            BaseItemRenderer r = (BaseItemRenderer)tmp.getRenderer();
            if (tmp.getRenderer() == null) continue;
            r.checkEnablement(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childRendered(M parentElement, MUIElement element) {
        if (element instanceof MItem) {
            List<I> list = this.widgets;
            synchronized (list) {
                this.widgets.add(element);
            }
        }
        this.do_childRendered(parentElement, element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideChild(M container, MUIElement changedObj) {
        if (changedObj instanceof MItem) {
            List<I> list = this.widgets;
            synchronized (list) {
                this.widgets.remove(changedObj);
            }
        }
        this.do_hideChild(container, changedObj);
    }

    protected abstract void do_init(@NonNull IEventBroker var1);

    protected abstract void do_childRendered(@NonNull M var1, @NonNull MUIElement var2);

    protected abstract void do_hideChild(@NonNull M var1, @NonNull MUIElement var2);
}

