/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds;

import java.util.List;
import org.apache.felix.scr.ScrService;
import org.eclipse.equinox.internal.ds.ScrServiceImpl;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer<ServiceComponentRuntime, ServiceRegistration<ScrService>> {
    private BundleContext bc;
    private Bundle scr;
    private ServiceTracker<ServiceComponentRuntime, ServiceRegistration<ScrService>> tracker;

    public void start(BundleContext context) throws Exception {
        this.bc = context;
        ServiceReference envInfoRef = context.getServiceReference(EnvironmentInfo.class);
        EnvironmentInfo envInfo = null;
        if (envInfoRef != null) {
            envInfo = (EnvironmentInfo)context.getService(envInfoRef);
        }
        if (envInfo != null) {
            envInfo.setProperty("ds.delayed.keepInstances", "true");
            envInfo.setProperty("equinox.use.ds", "true");
            context.ungetService(envInfoRef);
        } else {
            System.setProperty("ds.delayed.keepInstances", "true");
            System.setProperty("equinox.use.ds", "true");
        }
        BundleWiring wiring = (BundleWiring)context.getBundle().adapt(BundleWiring.class);
        List required = wiring.getRequiredWires("osgi.wiring.bundle");
        if (required.isEmpty()) {
            throw new IllegalStateException("No org.apache.felix.scr bundle found!");
        }
        this.scr = ((BundleWire)required.get(0)).getProvider().getBundle();
        if (!"org.apache.felix.scr".equals(this.scr.getSymbolicName())) {
            throw new IllegalStateException("Required wrong bundle: " + this.scr);
        }
        BundleStartLevel equinoxSDstartLevel = (BundleStartLevel)context.getBundle().adapt(BundleStartLevel.class);
        BundleStartLevel scrStartLevel = (BundleStartLevel)this.scr.adapt(BundleStartLevel.class);
        scrStartLevel.setStartLevel(equinoxSDstartLevel.getStartLevel());
        this.scr.start(1);
        this.tracker = new ServiceTracker(context, ServiceComponentRuntime.class, (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.tracker.close();
        this.scr.stop(1);
    }

    public ServiceRegistration<ScrService> addingService(ServiceReference<ServiceComponentRuntime> reference) {
        ServiceComponentRuntime scrService = (ServiceComponentRuntime)this.bc.getService(reference);
        if (this.scr != null) {
            return this.bc.registerService(ScrService.class, (Object)new ScrServiceImpl(scrService, this.bc), null);
        }
        return null;
    }

    public void modifiedService(ServiceReference<ServiceComponentRuntime> reference, ServiceRegistration<ScrService> reg) {
    }

    public void removedService(ServiceReference<ServiceComponentRuntime> reference, ServiceRegistration<ScrService> reg) {
        reg.unregister();
        this.bc.ungetService(reference);
    }
}

