package org.eclipse.fx.formats.svg;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.Writer;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.formats.svg.svg.SvgClipPathElement;
import org.eclipse.fx.formats.svg.svg.SvgDefsElement;
import org.eclipse.fx.formats.svg.svg.SvgElement;
import org.eclipse.fx.formats.svg.svg.SvgGElement;
import org.eclipse.fx.formats.svg.svg.SvgImageElement;
import org.eclipse.fx.formats.svg.svg.SvgLinearGradientElement;
import org.eclipse.fx.formats.svg.svg.SvgPathElement;
import org.eclipse.fx.formats.svg.svg.SvgRectElement;
import org.eclipse.fx.formats.svg.svg.SvgStopElement;
import org.eclipse.fx.formats.svg.svg.SvgSvgElement;
import org.eclipse.fx.formats.svg.svg.SvgTextElement;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class SvgSerializer {
  private SvgSvgElement e;
  
  public SvgSerializer(final SvgSvgElement e) {
    this.e = e;
  }
  
  public void toSvg(final Writer w) {
    try {
      CharSequence _gen = this.gen();
      w.append(_gen);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public CharSequence gen() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<?xml version=\"1.0\" standalone=\"no\"?>");
    _builder.newLine();
    _builder.append("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">");
    _builder.newLine();
    _builder.append("<svg width=\"");
    String _width = this.e.getWidth();
    _builder.append(_width, "");
    _builder.append("\" height=\"");
    String _height = this.e.getHeight();
    _builder.append(_height, "");
    _builder.append("\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">");
    _builder.newLineIfNotEmpty();
    {
      EList<SvgElement> _children = this.e.getChildren();
      for(final SvgElement c : _children) {
        _builder.append("\t");
        CharSequence _handle = this.handle(c);
        _builder.append(_handle, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("</svg>");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _handle(final SvgGElement e) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<g");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("transform=\"");
    String _transform = e.getTransform();
    _builder.append(_transform, "\t");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      if (((!StringExtensions.isNullOrEmpty(e.getClip_path())) && (!Objects.equal(e.getClip_path(), "none")))) {
        _builder.append("clip-path=\"");
        String _clip_path = e.getClip_path();
        _builder.append(_clip_path, "\t");
        _builder.append("\"");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append(">");
    _builder.newLine();
    {
      EList<SvgElement> _children = e.getChildren();
      for(final SvgElement c : _children) {
        _builder.append("\t");
        CharSequence _handle = this.handle(c);
        _builder.append(_handle, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("</g>");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _handle(final SvgRectElement e) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<rect");
    _builder.newLine();
    _builder.append("\t");
    {
      String _x = e.getX();
      boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(_x);
      boolean _not = (!_isNullOrEmpty);
      if (_not) {
        _builder.append("x=\"");
        String _x_1 = e.getX();
        _builder.append(_x_1, "\t");
        _builder.append("\"");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      String _y = e.getY();
      boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty(_y);
      boolean _not_1 = (!_isNullOrEmpty_1);
      if (_not_1) {
        _builder.append("y=\"");
        String _y_1 = e.getY();
        _builder.append(_y_1, "\t");
        _builder.append("\"");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      String _rx = e.getRx();
      boolean _isNullOrEmpty_2 = StringExtensions.isNullOrEmpty(_rx);
      boolean _not_2 = (!_isNullOrEmpty_2);
      if (_not_2) {
        _builder.append("rx=\"");
        String _rx_1 = e.getRx();
        _builder.append(_rx_1, "\t");
        _builder.append("\"");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      String _ry = e.getRy();
      boolean _isNullOrEmpty_3 = StringExtensions.isNullOrEmpty(_ry);
      boolean _not_3 = (!_isNullOrEmpty_3);
      if (_not_3) {
        _builder.append("ry=\"");
        String _ry_1 = e.getRy();
        _builder.append(_ry_1, "\t");
        _builder.append("\"");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("width=\"");
    String _width = e.getWidth();
    _builder.append(_width, "\t");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("height=\"");
    String _height = e.getHeight();
    _builder.append(_height, "\t");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      String _fill = e.getFill();
      boolean _isNullOrEmpty_4 = StringExtensions.isNullOrEmpty(_fill);
      boolean _not_4 = (!_isNullOrEmpty_4);
      if (_not_4) {
        _builder.append("fill=\"");
        String _fill_1 = e.getFill();
        _builder.append(_fill_1, "\t");
        _builder.append("\"");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      String _fill_opacity = e.getFill_opacity();
      boolean _isNullOrEmpty_5 = StringExtensions.isNullOrEmpty(_fill_opacity);
      boolean _not_5 = (!_isNullOrEmpty_5);
      if (_not_5) {
        _builder.append("fill-opacity=\"");
        String _fill_opacity_1 = e.getFill_opacity();
        _builder.append(_fill_opacity_1, "\t");
        _builder.append("\"");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    {
      if (((!StringExtensions.isNullOrEmpty(e.getStroke())) && (!Objects.equal(e.getStroke(), "none")))) {
        _builder.append("stroke=\"");
        String _stroke = e.getStroke();
        _builder.append(_stroke, "\t");
        _builder.append("\"");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      String _stroke_width = e.getStroke_width();
      boolean _isNullOrEmpty_6 = StringExtensions.isNullOrEmpty(_stroke_width);
      boolean _not_6 = (!_isNullOrEmpty_6);
      if (_not_6) {
        _builder.append("stroke-width=\"");
        String _stroke_width_1 = e.getStroke_width();
        _builder.append(_stroke_width_1, "\t");
        _builder.append("\"");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("/>");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _handle(final SvgTextElement e) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<text");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("x=\"");
    String _x = e.getX();
    _builder.append(_x, "\t");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("y=\"");
    String _y = e.getY();
    _builder.append(_y, "\t");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("fill=\"");
    String _fill = e.getFill();
    _builder.append(_fill, "\t");
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _textContent = e.getTextContent();
    _builder.append(_textContent, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("</text>");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _handle(final SvgDefsElement e) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<defs>");
    _builder.newLine();
    {
      EList<SvgElement> _children = e.getChildren();
      for(final SvgElement c : _children) {
        _builder.append("\t");
        CharSequence _handle = this.handle(c);
        _builder.append(_handle, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("</defs>");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _handle(final SvgPathElement e) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<path");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("d=\"");
    String _d = e.getD();
    _builder.append(_d, "\t");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      String _fill = e.getFill();
      boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(_fill);
      boolean _not = (!_isNullOrEmpty);
      if (_not) {
        _builder.append("fill=\"");
        String _fill_1 = e.getFill();
        _builder.append(_fill_1, "\t");
        _builder.append("\"");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("/>");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _handle(final SvgImageElement e) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<image");
    _builder.newLine();
    _builder.append("/>");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _handle(final SvgLinearGradientElement e) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<linearGradient id=\"");
    String _id = e.getId();
    _builder.append(_id, "");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("x1=\"");
    String _x1 = e.getX1();
    _builder.append(_x1, "\t");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("y1=\"");
    String _y1 = e.getY1();
    _builder.append(_y1, "\t");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("x2=\"");
    String _x2 = e.getX2();
    _builder.append(_x2, "\t");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("y2=\"");
    String _y2 = e.getY2();
    _builder.append(_y2, "\t");
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    {
      EList<SvgElement> _children = e.getChildren();
      Iterable<SvgStopElement> _filter = Iterables.<SvgStopElement>filter(_children, SvgStopElement.class);
      for(final SvgStopElement s : _filter) {
        _builder.append("\t");
        _builder.append("<stop offset=\"");
        String _offset = s.getOffset();
        _builder.append(_offset, "\t");
        _builder.append("\" stop-color=\"");
        String _stop_color = s.getStop_color();
        _builder.append(_stop_color, "\t");
        _builder.append("\" />");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("</linearGradient>");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _handle(final SvgClipPathElement e) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<clipPath id=\"");
    String _id = e.getId();
    _builder.append(_id, "");
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    {
      EList<SvgElement> _children = e.getChildren();
      for(final SvgElement c : _children) {
        _builder.append("\t");
        CharSequence _handle = this.handle(c);
        _builder.append(_handle, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("</clipPath>");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence handle(final EObject e) {
    if (e instanceof SvgDefsElement) {
      return _handle((SvgDefsElement)e);
    } else if (e instanceof SvgGElement) {
      return _handle((SvgGElement)e);
    } else if (e instanceof SvgClipPathElement) {
      return _handle((SvgClipPathElement)e);
    } else if (e instanceof SvgImageElement) {
      return _handle((SvgImageElement)e);
    } else if (e instanceof SvgLinearGradientElement) {
      return _handle((SvgLinearGradientElement)e);
    } else if (e instanceof SvgPathElement) {
      return _handle((SvgPathElement)e);
    } else if (e instanceof SvgRectElement) {
      return _handle((SvgRectElement)e);
    } else if (e instanceof SvgTextElement) {
      return _handle((SvgTextElement)e);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(e).toString());
    }
  }
}
