/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.merge.java.facade.ast;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.JCompilationUnit;
import org.eclipse.emf.codegen.merge.java.facade.JNode;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJAnnotation;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJAnnotationType;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJAnnotationTypeMember;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJCompilationUnit;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJEnum;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJEnumConstant;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJField;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJImport;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJInitializer;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJMethod;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJNode;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJPackage;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJType;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTNodeConverter;
import org.eclipse.emf.codegen.merge.java.facade.ast.CommentAwareSourceRangeComputer;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.jdt.internal.core.dom.rewrite.ListRewriteEvent;
import org.eclipse.jdt.internal.core.dom.rewrite.NodeRewriteEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTFacadeHelper
extends FacadeHelper {
    protected static final boolean DEBUG = false;
    protected ASTNodeConverter nodeConverter = null;
    protected Map<?, ?> javaCoreOptions = null;
    protected Map<ASTNode, String> nodeContents = new HashMap<ASTNode, String>();

    public static String toString(Name name) {
        return name == null ? null : name.getFullyQualifiedName();
    }

    public static String getTypeErasure(ArrayType arrayType) {
        StringBuilder sb = new StringBuilder(ASTFacadeHelper.getTypeErasure(arrayType.getElementType()));
        int i = arrayType.getDimensions();
        while (i > 0) {
            sb.append("[]");
            --i;
        }
        return sb.toString();
    }

    public static String getTypeErasure(ParameterizedType parameterizedType) {
        return ASTFacadeHelper.getTypeErasure(parameterizedType.getType());
    }

    public static String getTypeErasure(PrimitiveType primitiveType) {
        return primitiveType.getPrimitiveTypeCode().toString();
    }

    public static String getTypeErasure(SimpleType simpleType) {
        return ASTFacadeHelper.toString(simpleType.getName());
    }

    public static String getTypeErasure(QualifiedType qualifiedType) {
        StringBuilder sb = new StringBuilder(ASTFacadeHelper.getTypeErasure(qualifiedType.getQualifier()));
        sb.append(".");
        sb.append(ASTFacadeHelper.toString((Name)qualifiedType.getName()));
        return sb.toString();
    }

    public static String getTypeErasure(Type type) {
        if (type != null) {
            if (type.isArrayType()) {
                return ASTFacadeHelper.getTypeErasure((ArrayType)type);
            }
            if (type.isParameterizedType()) {
                return ASTFacadeHelper.getTypeErasure((ParameterizedType)type);
            }
            if (type.isPrimitiveType()) {
                return ASTFacadeHelper.getTypeErasure((PrimitiveType)type);
            }
            if (type.isQualifiedType()) {
                return ASTFacadeHelper.getTypeErasure((QualifiedType)type);
            }
            if (type.isSimpleType()) {
                return ASTFacadeHelper.getTypeErasure((SimpleType)type);
            }
            if (type.isWildcardType()) {
                return "";
            }
        }
        return "";
    }

    @Override
    public void reset() {
        this.nodeConverter = null;
        this.nodeContents.clear();
        super.reset();
    }

    protected ASTParser createASTParser() {
        ASTParser astParser = CodeGenUtil.EclipseUtil.newASTParser();
        HashMap<String, String> javaCoreOptions = new HashMap<String, String>();
        for (Map.Entry<?, ?> entry : this.getJavaCoreOptions().entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof String) || !(value instanceof String)) continue;
            javaCoreOptions.put((String)key, (String)value);
        }
        astParser.setCompilerOptions(javaCoreOptions);
        return astParser;
    }

    @Override
    public ASTJCompilationUnit createCompilationUnit(String name, String contents) {
        char[] contentAsCharArray = contents.toCharArray();
        ASTParser astParser = this.createASTParser();
        astParser.setSource(contentAsCharArray);
        CompilationUnit astCompilationUnit = (CompilationUnit)astParser.createAST(null);
        Diagnostic diagnostic = this.analyzeCompilationUnit(astCompilationUnit, contents);
        if (diagnostic != Diagnostic.OK_INSTANCE) {
            StringBuilder message = new StringBuilder(diagnostic.getMessage());
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                message.append("\n\t").append(childDiagnostic.getMessage());
            }
            message.append(contents);
            CodeGenPlugin.INSTANCE.log(message.toString());
            if (diagnostic.getSeverity() == 4) {
                throw new WrappedException((Exception)new DiagnosticException(diagnostic));
            }
        }
        ASTRewrite rewriter = ASTRewrite.create((AST)astCompilationUnit.getAST());
        rewriter.setTargetSourceRangeComputer((TargetSourceRangeComputer)new CommentAwareSourceRangeComputer(astCompilationUnit, contents));
        astCompilationUnit.setProperty("ASTJCompilationUnit.name", (Object)name);
        ASTJCompilationUnit compilationUnit = (ASTJCompilationUnit)this.convertToNode(astCompilationUnit);
        compilationUnit.setOriginalContents(contentAsCharArray);
        compilationUnit.setRewriter(rewriter);
        return compilationUnit;
    }

    @Override
    public String getOriginalContents(JCompilationUnit compilationUnit) {
        return new String(((ASTJCompilationUnit)compilationUnit).getOriginalContents());
    }

    private Diagnostic analyzeCompilationUnit(CompilationUnit compilationUnit, String contents) {
        Object[] objectArray;
        if (compilationUnit.getProblems().length == 0) {
            return Diagnostic.OK_INSTANCE;
        }
        String string = CodeGenPlugin.INSTANCE.getString("_UI_ParsingProblem_message");
        if (contents == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = new StringBuilder(contents);
        }
        BasicDiagnostic diagnostic = new BasicDiagnostic("org.eclipse.emf.codegen", 0, string, objectArray);
        IProblem[] iProblemArray = compilationUnit.getProblems();
        int n = iProblemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray3;
            IProblem problem = iProblemArray[n2];
            String message = problem.getMessage() != null ? CodeGenPlugin.INSTANCE.getString("_UI_LineNumberAndText_message", new Object[]{problem.getSourceLineNumber(), problem.getMessage()}) : CodeGenPlugin.INSTANCE.getString("_UI_LineNumber_message", new Object[]{problem.getSourceLineNumber()});
            int n3 = problem.isWarning() ? 2 : 4;
            String string2 = message.toString();
            if (contents == null) {
                Object[] objectArray4 = new Object[1];
                objectArray3 = objectArray4;
                objectArray4[0] = problem;
            } else {
                Object[] objectArray5 = new Object[2];
                objectArray5[0] = problem;
                objectArray3 = objectArray5;
                objectArray5[1] = new StringBuilder(contents);
            }
            BasicDiagnostic childDiagnostic = new BasicDiagnostic(n3, "org.eclipse.emf.codegen", 0, string2, objectArray3);
            diagnostic.add((Diagnostic)childDiagnostic);
            ++n2;
        }
        return diagnostic;
    }

    public Map<?, ?> getJavaCoreOptions() {
        if (this.javaCoreOptions == null) {
            this.javaCoreOptions = this.getDefaultJavaCoreOptions();
        }
        return this.javaCoreOptions;
    }

    private Map<?, ?> getDefaultJavaCoreOptions() {
        String indent;
        HashMap<Object, String> javaCoreOptions = new HashMap<Object, String>(JavaCore.getOptions());
        if (this.compilerCompliance != null) {
            javaCoreOptions.put("org.eclipse.jdt.core.compiler.compliance", this.compilerCompliance);
            javaCoreOptions.put("org.eclipse.jdt.core.compiler.source", this.compilerCompliance);
            javaCoreOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", this.compilerCompliance);
        } else {
            this.useCurrentOption(javaCoreOptions, "org.eclipse.jdt.core.compiler.compliance", "1.5");
            this.useCurrentOption(javaCoreOptions, "org.eclipse.jdt.core.compiler.source", "1.5");
            this.useCurrentOption(javaCoreOptions, "org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        }
        this.useCurrentOption(javaCoreOptions, "org.eclipse.jdt.core.formatter.tabulation.char", "space");
        this.useCurrentOption(javaCoreOptions, "org.eclipse.jdt.core.formatter.tabulation.size", "2");
        this.useCurrentOption(javaCoreOptions, "org.eclipse.jdt.core.formatter.indentation.size", "2");
        javaCoreOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        if (this.getControlModel() != null && (indent = this.getControlModel().getLeadingTabReplacement()) != null && indent.length() > 0) {
            String size = Integer.toString(indent.length());
            if (indent.charAt(0) == '\t') {
                javaCoreOptions.put("org.eclipse.jdt.core.formatter.tabulation.char", "tab");
                javaCoreOptions.put("org.eclipse.jdt.core.formatter.tabulation.size", size);
                javaCoreOptions.put("org.eclipse.jdt.core.formatter.indentation.size", size);
            } else if (indent.charAt(0) == ' ') {
                javaCoreOptions.put("org.eclipse.jdt.core.formatter.tabulation.char", "space");
                javaCoreOptions.put("org.eclipse.jdt.core.formatter.tabulation.size", size);
                javaCoreOptions.put("org.eclipse.jdt.core.formatter.indentation.size", size);
            }
        }
        javaCoreOptions.put("org.eclipse.jdt.core.incompleteClasspath", "warning");
        javaCoreOptions.put("org.eclipse.jdt.core.circularClasspath", "warning");
        javaCoreOptions.put("org.eclipse.jdt.core.formatter.brace_position_for_enum_declaration", "next_line");
        javaCoreOptions.put("org.eclipse.jdt.core.formatter.brace_position_for_type_declaration", "next_line");
        javaCoreOptions.put("org.eclipse.jdt.core.formatter.blank_lines_before_field", "1");
        javaCoreOptions.put("org.eclipse.jdt.core.formatter.alignment_for_enum_constants", DefaultCodeFormatterConstants.createAlignmentValue((boolean)true, (int)3, (int)0));
        return javaCoreOptions;
    }

    protected void useCurrentOption(Map<Object, String> options, String option) {
        this.useCurrentOption(options, option, null);
    }

    protected void useCurrentOption(Map<Object, String> options, String option, String defaultValue) {
        String value = JavaCore.getOption((String)option);
        if (value != null) {
            options.put(option, value);
        } else if (!options.containsKey(option) && defaultValue != null) {
            options.put(option, defaultValue);
        }
    }

    @Override
    public ASTNodeConverter getNodeConverter() {
        if (this.nodeConverter == null) {
            this.nodeConverter = new ASTNodeConverter(this);
        }
        return this.nodeConverter;
    }

    @Override
    public Object getContext(JNode node) {
        return node;
    }

    @Override
    public ASTJNode<?> cloneNode(Object context, JNode node) {
        if (node instanceof JCompilationUnit) {
            String content = this.applyFormatRules(this.toString(node.getContents()));
            return this.createCompilationUnit(node.getName(), content);
        }
        ASTJNode newASTJNode = null;
        Object originalASTNode = ((ASTJNode)node).getASTNode();
        ASTJNode contextNode = (ASTJNode)context;
        ASTRewrite rewriter = contextNode.getRewriter();
        if (node instanceof ASTJField) {
            newASTJNode = this.cloneField((ASTJField)node, contextNode);
        } else {
            String contents = this.applyFormatRules(node.getContents());
            ASTNode newASTNode = rewriter.createStringPlaceholder(contents, originalASTNode.getNodeType());
            newASTJNode = (ASTJNode)this.convertToNode(newASTNode);
            newASTJNode.trackAndReplace(newASTNode, contents);
        }
        newASTJNode.setRewriter(contextNode.getRewriter());
        return newASTJNode;
    }

    protected ASTJField cloneField(ASTJField originalField, ASTJNode<?> contextNode) {
        ASTJField newField = null;
        FieldDeclaration originalFieldDeclaration = originalField.getOriginalFieldDeclaration();
        if (originalFieldDeclaration.fragments().size() > 1) {
            AST ast = contextNode.getWrappedObject().getAST();
            FieldDeclaration newFieldDeclaration = (FieldDeclaration)ASTNode.copySubtree((AST)ast, (ASTNode)originalFieldDeclaration);
            List newFragmentsList = newFieldDeclaration.fragments();
            newFragmentsList.clear();
            ASTNode newASTNode = ASTNode.copySubtree((AST)ast, (ASTNode)originalField.getWrappedVariableDeclarationFragment());
            newFragmentsList.add(newASTNode);
            newField = (ASTJField)this.convertToNode(newASTNode);
            newField.setRewriter(contextNode.getRewriter());
            newField.setComment(originalField.getComment());
            newField.setInitializer(originalField.getInitializer());
            Iterator<JNode> originalChildrenIterator = originalField.getChildren().iterator();
            Iterator<JNode> childrenIterator = newField.getChildren().iterator();
            while (childrenIterator.hasNext() && originalChildrenIterator.hasNext()) {
                ASTJAnnotation originalAnnotation = (ASTJAnnotation)originalChildrenIterator.next();
                ASTJAnnotation annotation = (ASTJAnnotation)childrenIterator.next();
                annotation.setContents(this.applyFormatRules(originalAnnotation.getContents()));
            }
        } else {
            String contents = this.applyFormatRules(originalField.getContents());
            FieldDeclaration fieldDeclaration = (FieldDeclaration)contextNode.getRewriter().createStringPlaceholder(contents, 23);
            newField = (ASTJField)this.convertToNode(fieldDeclaration.fragments().get(0));
            newField.trackAndReplace((ASTNode)fieldDeclaration, contents);
        }
        return newField;
    }

    public ASTJNode<?> findParent(ASTNode node) {
        JNode parent = null;
        while ((parent = this.convertToNode(node = node.getParent())) == null && node != null) {
        }
        return (ASTJNode)parent;
    }

    @Override
    protected ASTJNode<?> doConvertToNode(Object object) {
        ASTJNode node = null;
        if (object instanceof ASTNode) {
            ASTNode astNode = (ASTNode)object;
            ASTRewrite rewriter = null;
            ASTJCompilationUnit compilationUnit = (ASTJCompilationUnit)this.getCompilationUnit(this.findParent((ASTNode)object));
            if (compilationUnit != null) {
                rewriter = compilationUnit.getRewriter();
            }
            boolean isCompilationUnit = false;
            switch (astNode.getNodeType()) {
                case 15: {
                    node = new ASTJCompilationUnit((CompilationUnit)object);
                    isCompilationUnit = true;
                    break;
                }
                case 59: {
                    node = new ASTJField((VariableDeclarationFragment)object, this, rewriter);
                    break;
                }
                case 26: {
                    node = new ASTJImport((ImportDeclaration)object);
                    break;
                }
                case 28: {
                    node = new ASTJInitializer((Initializer)object);
                    break;
                }
                case 31: {
                    node = new ASTJMethod((MethodDeclaration)object);
                    break;
                }
                case 35: {
                    node = new ASTJPackage((PackageDeclaration)object);
                    break;
                }
                case 55: {
                    node = new ASTJType((TypeDeclaration)object);
                    break;
                }
                case 77: 
                case 78: 
                case 79: {
                    node = new ASTJAnnotation((Annotation)object);
                    break;
                }
                case 81: {
                    node = new ASTJAnnotationType((AnnotationTypeDeclaration)object);
                    break;
                }
                case 82: {
                    node = new ASTJAnnotationTypeMember((AnnotationTypeMemberDeclaration)object);
                    break;
                }
                case 71: {
                    node = new ASTJEnum((EnumDeclaration)object);
                    break;
                }
                case 72: {
                    node = new ASTJEnumConstant((EnumConstantDeclaration)object);
                }
            }
            if (node != null) {
                node.setFacadeHelper(this);
                if (!isCompilationUnit) {
                    node.setRewriter(rewriter);
                }
            }
        }
        return node;
    }

    public void updateObjectToNodeMap(ASTJNode<?> node) {
        this.objectToNodeMap.put(node instanceof ASTJField ? ((ASTJField)node).getWrappedVariableDeclarationFragment() : node.getWrappedObject(), node);
    }

    @Override
    public boolean addChild(JNode node, JNode child) {
        if (node == null) {
            return false;
        }
        return ((ASTJNode)node).addChild((ASTJNode)child);
    }

    @Override
    public boolean remove(JNode node) {
        ASTJNode astjNode;
        JNode parent;
        if (node != null && (parent = (astjNode = (ASTJNode)node).getParent()) != null) {
            if (((ASTJNode)parent).remove(astjNode)) {
                this.updateObjectToNodeMap(astjNode);
            }
            return true;
        }
        return false;
    }

    @Override
    public void commentOut(JNode node) {
        ASTJNode astjNode = (ASTJNode)node;
        astjNode.commentOut();
    }

    @Override
    public boolean insertSibling(JNode node, JNode newSibling, boolean before) {
        ASTJNode astjNode;
        JNode parent;
        if (node != null && newSibling != null && (parent = (astjNode = (ASTJNode)node).getParent()) != null) {
            return ((ASTJNode)parent).insertSibling(astjNode, (ASTJNode)newSibling, before);
        }
        return false;
    }

    @Override
    public String toString(Object object) {
        if (object instanceof ASTJNode) {
            return this.toString((ASTNode)((ASTJNode)object).getASTNode());
        }
        if (object instanceof ASTNode) {
            return this.toString((ASTNode)object);
        }
        return super.toString(object);
    }

    public String toString(ASTNode node) {
        ASTJCompilationUnit compilationUnit;
        if (node == null) {
            return null;
        }
        if (this.nodeContents.containsKey(node)) {
            return this.nodeContents.get(node);
        }
        JNode root = this.convertToNode(node.getRoot());
        if (root == null || !(root instanceof ASTJCompilationUnit)) {
            root = this.getCompilationUnit(this.convertToNode(node));
        }
        if ((compilationUnit = (ASTJCompilationUnit)root) != null) {
            char[] originalContents = compilationUnit.getOriginalContents();
            int start = node.getStartPosition();
            int length = node.getLength();
            TargetSourceRangeComputer rangeComputer = compilationUnit.getRewriter().getExtendedSourceRangeComputer();
            if (rangeComputer instanceof CommentAwareSourceRangeComputer) {
                TargetSourceRangeComputer.SourceRange sourceRange = ((CommentAwareSourceRangeComputer)rangeComputer).computeDefaultSourceRange(node);
                length = sourceRange.getStartPosition() + sourceRange.getLength() - start;
            }
            String resultString = null;
            if (start >= 0 && start + length <= originalContents.length) {
                resultString = new String(originalContents, start, length);
            }
            this.nodeContents.put(node, resultString);
            return resultString;
        }
        return node.toString();
    }

    public void logInfo(String string) {
        CodeGenPlugin.INSTANCE.log("INFO " + string);
    }

    public void logError(String string) {
        CodeGenPlugin.INSTANCE.log("ERROR " + string);
    }

    public void logError(String string, Exception e) {
        CodeGenPlugin.INSTANCE.log("ERROR " + string);
        CodeGenPlugin.INSTANCE.log(e);
    }

    @Deprecated
    public static class ASTRewriteWithRemove
    extends ASTRewrite {
        protected ASTRewriteWithRemove(AST ast) {
            super(ast);
        }

        public void dispose() {
            this.getRewriteEventStore().clear();
            this.getNodeStore().clear();
            this.setTargetSourceRangeComputer(null);
        }

        public void remove(ASTNode parent, ChildListPropertyDescriptor childProperty, ASTNode node) {
            ListRewrite lrw = this.getListRewrite(parent, childProperty);
            if (lrw.getRewrittenList().contains(node) && !lrw.getOriginalList().contains(node)) {
                ListRewriteEvent listEvent = super.getRewriteEventStore().getListEvent(parent, (StructuralPropertyDescriptor)childProperty, true);
                int index = listEvent.getIndex(node, 1);
                if (index >= 0) {
                    listEvent.revertChange((NodeRewriteEvent)listEvent.getChildren()[index]);
                } else {
                    lrw.remove(node, null);
                }
            } else {
                lrw.remove(node, null);
            }
        }
    }
}

