/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.tasks;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.IPreferenceValuesProvider;
import org.eclipse.xtext.preferences.PreferenceKey;
import org.eclipse.xtext.tasks.ITaskTagProvider;
import org.eclipse.xtext.tasks.Priority;
import org.eclipse.xtext.tasks.TaskTag;
import org.eclipse.xtext.tasks.TaskTags;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class PreferenceTaskTagProvider
implements ITaskTagProvider {
    public static final PreferenceKey TAGS_KEY = new PreferenceKey("task.tags", "TODO,FIXME,XXX");
    public static final PreferenceKey PRIORITIES_KEY = new PreferenceKey("task.priorities", "NORMAL,HIGH,NORMAL");
    public static final PreferenceKey CASE_SENSITIVE_KEY = new PreferenceKey("task.caseSensitive", "true");
    public static final List<PreferenceKey> KEYS = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new PreferenceKey[]{TAGS_KEY, PRIORITIES_KEY, CASE_SENSITIVE_KEY}));
    private IPreferenceValuesProvider preferenceValuesProvider;

    public static List<TaskTag> parseTags(String names, String priorities) {
        Splitter splitter = Splitter.on((String)",").omitEmptyStrings().trimResults();
        List tags = IterableExtensions.toList((Iterable)splitter.split((CharSequence)names));
        List prios = IterableExtensions.toList((Iterable)splitter.split((CharSequence)priorities));
        ArrayList elements = CollectionLiterals.newArrayList();
        int _size = tags.size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
        for (Integer i : _doubleDotLessThan) {
            TaskTag _taskTag = new TaskTag();
            Procedures.Procedure1 _function = it -> {
                boolean _greaterEqualsThan;
                it.setName((String)tags.get(i));
                Priority _xifexpression = null;
                int _size_1 = prios.size();
                boolean bl = _greaterEqualsThan = _size_1 >= i;
                if (_greaterEqualsThan) {
                    Priority _xtrycatchfinallyexpression = null;
                    try {
                        _xtrycatchfinallyexpression = Priority.valueOf((String)prios.get(i));
                    }
                    catch (Throwable _t) {
                        if (_t instanceof IllegalArgumentException) {
                            _xtrycatchfinallyexpression = Priority.NORMAL;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    _xifexpression = _xtrycatchfinallyexpression;
                } else {
                    _xifexpression = Priority.NORMAL;
                }
                it.setPriority(_xifexpression);
            };
            TaskTag _doubleArrow = (TaskTag)ObjectExtensions.operator_doubleArrow((Object)_taskTag, (Procedures.Procedure1)_function);
            elements.add(_doubleArrow);
        }
        return elements;
    }

    public static String serializeTags(List<TaskTag> tags) {
        Functions.Function1 _function = it -> it.getName();
        return Joiner.on((String)",").join((Iterable)ListExtensions.map(tags, (Functions.Function1)_function));
    }

    public static String serializePriorities(List<TaskTag> tags) {
        Functions.Function1 _function = it -> it.getPriority();
        return Joiner.on((String)",").join((Iterable)ListExtensions.map(tags, (Functions.Function1)_function));
    }

    @Override
    public TaskTags getTaskTags(Resource resource) {
        TaskTags _xblockexpression = null;
        IPreferenceValues prefs = this.preferenceValuesProvider.getPreferenceValues(resource);
        String names = prefs.getPreference(TAGS_KEY);
        String priorities = prefs.getPreference(PRIORITIES_KEY);
        TaskTags _taskTags = new TaskTags();
        Procedures.Procedure1 _function = it -> {
            it.setCaseSensitive(Boolean.valueOf(prefs.getPreference(CASE_SENSITIVE_KEY)));
            List<TaskTag> _taskTags_1 = it.getTaskTags();
            List<TaskTag> _parseTags = PreferenceTaskTagProvider.parseTags(names, priorities);
            Iterables.addAll(_taskTags_1, _parseTags);
        };
        _xblockexpression = (TaskTags)ObjectExtensions.operator_doubleArrow((Object)_taskTags, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    @Inject
    public void setPreferenceValuesProvider(IPreferenceValuesProvider preferenceValuesProvider) {
        this.preferenceValuesProvider = preferenceValuesProvider;
    }
}

