/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javafx.scene.Node;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.ui.controls.dialog.Dialog;
import org.eclipse.fx.ui.controls.dialog.MessageDialog;
import org.eclipse.fx.ui.controls.stage.FrameEvent;
import org.eclipse.fx.ui.dialogs.MessageDialog;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWindow;
import org.eclipse.fx.ui.workbench.renderers.fx.internal.Messages;
import org.eclipse.fx.ui.workbench.renderers.fx.internal.MultiMessageDialog;
import org.eclipse.fx.ui.workbench.renderers.fx.internal.MultiMessageDialogContent;
import org.eclipse.fx.ui.workbench.renderers.fx.internal.Row;
import org.eclipse.fx.ui.workbench.renderers.fx.services.SaveDialogPresenter;
import org.eclipse.jdt.annotation.NonNull;

public class DefaultSaveDialogPresenter
implements SaveDialogPresenter {
    @Inject
    @Translation
    private @NonNull Messages messages;
    @Inject
    private ThreadSynchronize uiSync;
    @Inject
    GraphicsLoader graphicsLoader;

    @Override
    public CompletableFuture<List<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ISaveHandler.Save>> promptToSave(SaveDialogPresenter.SaveData data) {
        if (data.dirtyParts.size() == 1) {
            return CompletableFuture.completedFuture(Collections.singletonList(this.promptToSave(data.lightweight, data.dirtyParts.iterator().next(), data.widget, data.window)));
        }
        return CompletableFuture.completedFuture(this.promptToSave(data.lightweight, data.dirtyParts, data.widget, data.window));
    }

    private @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ISaveHandler.Save> promptToSave(boolean lightweight, @NonNull Collection<MPart> dirtyParts, @NonNull WWindow<?> widget, @NonNull Window window) {
        Object[] response = new ISaveHandler.Save[dirtyParts.size()];
        if (lightweight) {
            Arrays.fill(response, ISaveHandler.Save.CANCEL);
            final MultiMessageDialogContent multiMessageDialogContent = new MultiMessageDialogContent(this.messages.DefWindowRenderer_MultiMessageDialog_Message, dirtyParts, this.graphicsLoader);
            Dialog d = new Dialog((Node)multiMessageDialogContent, this.messages.DefWindowRenderer_MultiMessageDialog_Title, (ISaveHandler.Save[])response){
                private final /* synthetic */ ISaveHandler.Save[] val$response;
                {
                    this.val$response = saveArray;
                    super($anonymous0, $anonymous1);
                }

                protected void handleOk() {
                    ArrayList<MPart> parts = new ArrayList<MPart>();
                    for (Row r : multiMessageDialogContent.tabView.getItems()) {
                        if (!r.isSelected()) continue;
                        parts.add((MPart)r.element.get());
                    }
                    Arrays.fill(this.val$response, ISaveHandler.Save.NO);
                    for (MPart p : parts) {
                        this.val$response[parts.indexOf((Object)p)] = ISaveHandler.Save.YES;
                    }
                    super.handleOk();
                }
            };
            d.getButtonList().addAll((Object[])new Dialog.DialogButton[]{d.createOKButton(), d.createCancelButton()});
            widget.setDialog((Object)d);
            ThreadSynchronize.BlockCondition condition = new ThreadSynchronize.BlockCondition();
            d.addEventHandler(FrameEvent.CLOSED, arg_0 -> ((ThreadSynchronize.BlockCondition)condition).release(arg_0));
            this.uiSync.block(condition);
            widget.setDialog(null);
        } else {
            MultiMessageDialog d = new MultiMessageDialog(window, dirtyParts, this.graphicsLoader, this.messages.DefWindowRenderer_MultiMessageDialog_Title, this.messages.DefWindowRenderer_MultiMessageDialog_Message);
            if (d.open() == 1) {
                List<MPart> parts = d.getSelectedParts();
                Arrays.fill(response, ISaveHandler.Save.NO);
                for (MPart p : parts) {
                    response[parts.indexOf((Object)p)] = ISaveHandler.Save.YES;
                }
            } else {
                Arrays.fill(response, ISaveHandler.Save.CANCEL);
            }
        }
        return Arrays.asList(response);
    }

    private ISaveHandler.Save promptToSave(boolean lightweight, MPart dirtyPart, WWindow<?> widget, Window stage) {
        if (lightweight) {
            MessageDialog.QuestionCancelResult r = MessageDialog.openQuestionCancelDialog((String)this.messages.DefWindowRenderer_promptToSave_Title, (String)this.messages.DefWindowRenderer_promptToSave_Message(dirtyPart.getLocalizedLabel()), d -> widget.setDialog(d));
            widget.setDialog(null);
            switch (r) {
                case CANCEL: {
                    return ISaveHandler.Save.CANCEL;
                }
                case NO: {
                    return ISaveHandler.Save.NO;
                }
                case YES: {
                    return ISaveHandler.Save.YES;
                }
            }
            return ISaveHandler.Save.CANCEL;
        }
        MessageDialog.QuestionCancelResult r = org.eclipse.fx.ui.dialogs.MessageDialog.openQuestionCancelDialog((Window)((Stage)widget.getWidget()), (String)this.messages.DefWindowRenderer_promptToSave_Title, (String)this.messages.DefWindowRenderer_promptToSave_Message(dirtyPart.getLocalizedLabel()));
        switch (r) {
            case CANCEL: {
                return ISaveHandler.Save.CANCEL;
            }
            case NO: {
                return ISaveHandler.Save.NO;
            }
            case YES: {
                return ISaveHandler.Save.YES;
            }
        }
        return ISaveHandler.Save.CANCEL;
    }
}

