/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.sun.javafx.scene.CssFlags;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.BoundingBox;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.PopupWindow;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.SystemUtils;
import org.eclipse.fx.core.geom.Size;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.core.text.TextUtil;
import org.eclipse.fx.ui.controls.JavaFXCompatUtil;
import org.eclipse.fx.ui.controls.internal.PseudoClassProperty;
import org.eclipse.fx.ui.controls.styledtext.StyledString;
import org.eclipse.fx.ui.controls.styledtext.StyledStringSegment;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class Util {
    public static final String FIND_NODE_EXCLUDE = "findNodeExclude";
    public static final boolean MNEMONICS_FIX = !Boolean.getBoolean("efxclipse.mnemonicfix.disabled");
    public static final String OPTIMIZE_ATTACH = "efxclipse.optimize.attach";
    private static final Logger logger = LoggerCreator.createLogger(Util.class);
    private static Cache<CacheKey, Size> FONT_SIZE_CACHE;

    public static String dumpSceneGraph(Node n) {
        return new SceneGraphDumper().dump(n).toString();
    }

    public static Node toNode(StyledString s) {
        ArrayList<Text> segList = new ArrayList<Text>();
        for (StyledStringSegment seg : s.getSegmentList()) {
            Text t = new Text(seg.getText());
            t.getStyleClass().addAll(seg.getStyleClass());
            segList.add(t);
        }
        TextFlow textFlow = new TextFlow(segList.toArray(new Node[0]));
        textFlow.getStyleClass().add((Object)"styled-string");
        return textFlow;
    }

    public static Node findNode(@Nullable Window w, double screenX, double screenY) {
        if (w != null && new BoundingBox(w.getX(), w.getY(), w.getWidth(), w.getHeight()).contains(screenX, screenY)) {
            return Util.findNode((Node)w.getScene().getRoot(), screenX, screenY);
        }
        Iterator<Window> impl_getWindows = JavaFXCompatUtil.getAllWindows().iterator();
        ArrayList<Window> sortedWindows = new ArrayList<Window>();
        HashMap<Window, ArrayList<Window>> parentChildRelation = new HashMap<Window, ArrayList<Window>>();
        while (impl_getWindows.hasNext()) {
            Window window = impl_getWindows.next();
            Object owner = window instanceof Stage ? ((Stage)window).getOwner() : (window instanceof PopupWindow ? ((PopupWindow)window).getOwnerWindow() : null);
            if (owner == null) {
                sortedWindows.add(window);
                continue;
            }
            ArrayList<Window> list = (ArrayList<Window>)parentChildRelation.get(owner);
            if (list == null) {
                list = new ArrayList<Window>();
                parentChildRelation.put((Window)owner, list);
            }
            list.add(window);
        }
        while (!parentChildRelation.isEmpty()) {
            Window[] windowArray = sortedWindows.toArray(new Window[0]);
            int n = windowArray.length;
            int n2 = 0;
            while (n2 < n) {
                Window rw = windowArray[n2];
                List list = (List)parentChildRelation.remove(rw);
                if (list != null) {
                    sortedWindows.addAll(list);
                }
                ++n2;
            }
        }
        Collections.reverse(sortedWindows);
        for (Window window : sortedWindows) {
            if (FIND_NODE_EXCLUDE.equals(window.getUserData()) || !new BoundingBox(window.getX(), window.getY(), window.getWidth(), window.getHeight()).contains(screenX, screenY)) continue;
            return Util.findNode((Node)window.getScene().getRoot(), screenX, screenY);
        }
        return null;
    }

    public static Node findNode(Node n, double screenX, double screenY) {
        Node rv = null;
        if (!n.isVisible()) {
            return rv;
        }
        Point2D b = n.screenToLocal(screenX, screenY);
        if (n.getBoundsInLocal().contains(b) && !FIND_NODE_EXCLUDE.equals(n.getUserData())) {
            rv = n;
            if (n instanceof Parent) {
                List cList = ((Parent)n).getChildrenUnmodifiable().stream().filter(no -> no.isVisible()).collect(Collectors.toList());
                for (Node c : cList) {
                    Node cn = Util.findNode(c, screenX, screenY);
                    if (cn == null) continue;
                    rv = cn;
                    break;
                }
            }
        }
        return rv;
    }

    public static ObservableValue<Window> windowProperty(Node n) {
        SimpleObjectProperty w = new SimpleObjectProperty();
        ChangeListener l = (arg_0, arg_1, arg_2) -> Util.lambda$1((ObjectProperty)w, arg_0, arg_1, arg_2);
        ChangeListener sl = (o, oldV, newV) -> {
            if (oldV != null) {
                oldV.windowProperty().removeListener(l);
            }
            if (newV != null) {
                newV.windowProperty().addListener(l);
            }
        };
        n.getProperties().put((Object)"listener", (Object)sl);
        WeakChangeListener wl = new WeakChangeListener(sl);
        n.getProperties().put((Object)"wl_listener", (Object)wl);
        n.sceneProperty().addListener((ChangeListener)wl);
        return w;
    }

    public static <T, E> Subscription bindContent(List<T> target, final ObservableList<E> sourceList, Function<E, T> converterFunction) {
        List list = sourceList.stream().map(converterFunction).collect(Collectors.toList());
        if (target instanceof ObservableList) {
            ((ObservableList)target).setAll(list);
        } else {
            target.clear();
            target.addAll(list);
        }
        final ListChangeListener l = change -> {
            while (change.next()) {
                if (change.wasPermutated()) {
                    target.subList(change.getFrom(), change.getTo()).clear();
                    target.addAll(change.getFrom(), Util.transformList(change.getList().subList(change.getFrom(), change.getTo()), converterFunction));
                    continue;
                }
                if (change.wasRemoved()) {
                    target.subList(change.getFrom(), change.getFrom() + change.getRemovedSize()).clear();
                }
                if (!change.wasAdded()) continue;
                target.addAll(change.getFrom(), Util.transformList(change.getAddedSubList(), converterFunction));
            }
        };
        sourceList.addListener(l);
        return new Subscription(){

            public void dispose() {
                sourceList.removeListener(l);
            }
        };
    }

    public static <T, E> List<T> transformList(List<? extends E> list, Function<E, T> converterFunction) {
        return list.stream().map(converterFunction).collect(Collectors.toList());
    }

    public static Subscription installHoverCallback(Node node, Duration delay, Consumer<MouseEvent> hoverConsumer) {
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(delay, new KeyValue[0])});
        AtomicReference event = new AtomicReference();
        t.setOnFinished(e -> {
            if (event.get() != null) {
                hoverConsumer.accept((MouseEvent)event.get());
            }
        });
        EventHandler moveHandler = e -> {
            event.set(e);
            t.stop();
            t.playFromStart();
        };
        EventHandler exitHandler = e -> t.stop();
        node.addEventHandler(MouseEvent.MOUSE_MOVED, moveHandler);
        node.addEventHandler(MouseEvent.MOUSE_EXITED, exitHandler);
        return () -> {
            node.removeEventHandler(MouseEvent.MOUSE_MOVED, moveHandler);
            node.removeEventHandler(MouseEvent.MOUSE_EXITED, exitHandler);
        };
    }

    public static void enterNestedEventLoop(String id) {
        if (SystemUtils.getMajorFXVersion() > 8) {
            Util.enterNestedEventLoop9(id);
        } else {
            Util.enterNestedEventLoop8(id);
        }
    }

    private static void enterNestedEventLoop8(String id) {
        try {
            Class<?> toolkit = Class.forName("com.sun.javafx.tk.Toolkit");
            Object tk = toolkit.getMethod("getToolkit", new Class[0]).invoke(null, new Object[0]);
            toolkit.getMethod("enterNestedEventLoop", Object.class).invoke(tk, id);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static void enterNestedEventLoop9(String id) {
        try {
            Method m = Platform.class.getMethod("enterNestedEventLoop", Object.class);
            m.invoke(null, id);
        }
        catch (Throwable t) {
            Util.enterNestedEventLoop8(id);
        }
    }

    public static void exitNestedEventLoop(String id) {
        if (SystemUtils.getMajorFXVersion() > 8) {
            Util.exitNestedEventLoop9(id);
        } else {
            Util.exitNestedEventLoop8(id);
        }
    }

    private static void exitNestedEventLoop8(String id) {
        try {
            Class<?> toolkit = Class.forName("com.sun.javafx.tk.Toolkit");
            Object tk = toolkit.getMethod("getToolkit", new Class[0]).invoke(null, new Object[0]);
            toolkit.getMethod("exitNestedEventLoop", Object.class, Object.class).invoke(tk, id, null);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static void exitNestedEventLoop9(String id) {
        try {
            Method m = Platform.class.getMethod("exitNestedEventLoop", Object.class, Object.class);
            m.invoke(null, id, null);
        }
        catch (Throwable t) {
            Util.exitNestedEventLoop8(id);
        }
    }

    @Deprecated
    public static <T> @Nullable T waitUntil(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ThreadSynchronize.BlockCondition<T> blockCondition) {
        final AtomicReference<@Nullable V> rv = new AtomicReference();
        final String uuid = UUID.randomUUID().toString();
        blockCondition.subscribeUnblockedCallback(new Consumer<T>(){

            @Override
            public void accept(@Nullable T value) {
                rv.set(value);
                Util.exitNestedEventLoop(uuid);
            }
        });
        Util.enterNestedEventLoop(uuid);
        return (T)rv.get();
    }

    public static double getTextWidth(String text, Font font, double fontZoomFactor) {
        Text t = new Text(text);
        t.setFont(Font.font((String)font.getName(), (double)(font.getSize() * fontZoomFactor)));
        return t.getLayoutBounds().getWidth();
    }

    public static DoubleBinding createTextWidthBinding(ObservableValue<String> text, ObservableValue<Font> font, ObservableValue<Number> fontZoomFactor) {
        return Bindings.createDoubleBinding(() -> Util.getTextWidth((String)text.getValue(), (Font)font.getValue(), ((Number)fontZoomFactor.getValue()).doubleValue()), (Observable[])new Observable[]{text, font, fontZoomFactor});
    }

    public static DoubleBinding createTextWidthBinding(String text, ObservableValue<Font> font, ObservableValue<Number> fontZoomFactor) {
        return Bindings.createDoubleBinding(() -> Util.getTextWidth(text, (Font)font.getValue(), ((Number)fontZoomFactor.getValue()).doubleValue()), (Observable[])new Observable[]{font, fontZoomFactor});
    }

    public static double getTextHeight(String text, Font font, double fontZoomFactor) {
        Text t = new Text(text);
        t.setFont(Font.font((String)font.getName(), (double)(font.getSize() * fontZoomFactor)));
        return t.getLayoutBounds().getHeight();
    }

    public static DoubleBinding createTextHeightBinding(String text, ObservableValue<Font> font, ObservableValue<Number> fontZoomFactor) {
        return Bindings.createDoubleBinding(() -> Util.getTextHeight(text, (Font)font.getValue(), ((Number)fontZoomFactor.getValue()).doubleValue()), (Observable[])new Observable[]{font, fontZoomFactor});
    }

    public static boolean isCopyEvent(MouseEvent event) {
        if (SystemUtils.isMacOS()) {
            return event.isAltDown();
        }
        return event.isControlDown();
    }

    public static Size getSize(Font font, char c) {
        Size rv;
        if (FONT_SIZE_CACHE == null) {
            FONT_SIZE_CACHE = CacheBuilder.newBuilder().maximumSize(20L).build();
        }
        if ((rv = (Size)FONT_SIZE_CACHE.getIfPresent((Object)new CacheKey(font, c))) == null) {
            Text t = new Text(TextUtil.toString((char)c));
            t.setFont(font);
            rv = new Size(t.prefWidth(-1.0), t.prefHeight(-1.0));
            FONT_SIZE_CACHE.put((Object)new CacheKey(font, c), (Object)rv);
        }
        return rv;
    }

    public static Background getSimpleBackground(Paint p) {
        return new Background(new BackgroundFill[]{new BackgroundFill(p, CornerRadii.EMPTY, Insets.EMPTY)});
    }

    public static BooleanProperty createPseudoClassProperty(PseudoClass cls, Node node, String name, boolean def) {
        return PseudoClassProperty.create(cls, node, name, def);
    }

    public static BooleanProperty createPseudoClassProperty(String pseudoClass, Node node, String name, boolean def) {
        return PseudoClassProperty.create(pseudoClass, node, name, def);
    }

    public static <E extends Event> EventHandler<E> onEvent(Runnable r) {
        return e -> r.run();
    }

    public static <E extends Event> EventHandler<E> onEventConsume(BooleanSupplier r) {
        return e -> {
            if (r.getAsBoolean()) {
                e.consume();
            }
        };
    }

    public static void attachNode(Node node, Consumer<Node> attachToParent) {
        Util.attachNode(node, () -> attachToParent.accept(node));
    }

    public static void attachNode(Node node, Runnable attachToParent) {
        Util.disableStyle(node);
        attachToParent.run();
        Util.restoreStyle(node);
    }

    public static void disableStyle(Node node) {
        if (Boolean.getBoolean(OPTIMIZE_ATTACH)) {
            Util.disableCSS(node);
        }
    }

    public static void restoreStyle(Node node) {
        if (Boolean.getBoolean(OPTIMIZE_ATTACH)) {
            Util.enableCSS(node);
        }
    }

    private static void disableCSS(Node node) {
        Util.changeCSS(node, CssFlags.REAPPLY);
    }

    private static void changeCSS(Node node, CssFlags flag) {
        try {
            Field cssFlag = Node.class.getDeclaredField("cssFlag");
            boolean wasAccessible = cssFlag.isAccessible();
            cssFlag.setAccessible(true);
            Stack<Node> nodes = new Stack<Node>();
            nodes.add(node);
            while (!nodes.isEmpty()) {
                Node next = (Node)nodes.pop();
                if (next instanceof Parent) {
                    nodes.addAll((Collection<Node>)((Parent)next).getChildrenUnmodifiable());
                }
                cssFlag.set(next, flag);
            }
            cssFlag.setAccessible(wasAccessible);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            logger.warning("An error occurred while trying to disable styling; this may cause performance issues", (Throwable)e);
            return;
        }
    }

    private static void enableCSS(Node node) {
        node.applyCss();
    }

    private static /* synthetic */ void lambda$1(ObjectProperty objectProperty, ObservableValue o, Window oldV, Window newV) {
        objectProperty.set((Object)newV);
    }

    private static class CacheKey {
        private final Font f;
        private final char c;

        CacheKey(Font f, char c) {
            this.f = f;
            this.c = c;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.c;
            result = 31 * result + (this.f == null ? 0 : this.f.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.c != other.c) {
                return false;
            }
            return !(this.f == null ? other.f != null : !this.f.equals((Object)other.f));
        }
    }

    static class SceneGraphDumper {
        private StringBuilder sb = new StringBuilder();
        private int ident = 0;

        SceneGraphDumper() {
        }

        public StringBuilder dump(Node n) {
            int i = 0;
            while (i < this.ident) {
                this.sb.append("    ");
                ++i;
            }
            ++this.ident;
            this.sb.append("<" + n.getClass().getName() + " styleClass=\"" + n.getStyleClass() + "\">\n");
            if (n instanceof Parent) {
                for (Node subNode : ((Parent)n).getChildrenUnmodifiable()) {
                    this.dump(subNode);
                }
            }
            --this.ident;
            i = 0;
            while (i < this.ident) {
                this.sb.append("    ");
                ++i;
            }
            this.sb.append("</" + n.getClass().getName() + ">\n");
            return this.sb;
        }
    }
}

