/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.ITypeImporter;
import org.eclipse.xtext.xbase.typesystem.computation.IApplicableCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeAssigner;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationResult;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceFlags;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.CompoundTypeAssigner;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionAwareStackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.ResolutionBasedComputationResult;
import org.eclipse.xtext.xbase.typesystem.internal.TypeAssigner;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;

public class CompoundTypeComputationState
implements ITypeComputationState {
    private AbstractTypeComputationState[] components;
    private ITypeReferenceOwner owner;

    public CompoundTypeComputationState(ITypeReferenceOwner owner, AbstractTypeComputationState ... components) {
        this.owner = owner;
        this.components = components;
    }

    @Override
    public List<? extends IConstructorLinkingCandidate> getLinkingCandidates(XConstructorCall constructorCall) {
        ArrayList result = Lists.newArrayList();
        for (AbstractTypeComputationState component : this.components) {
            result.addAll(component.getLinkingCandidates(constructorCall));
        }
        return result;
    }

    @Override
    public List<? extends IFeatureLinkingCandidate> getLinkingCandidates(XAbstractFeatureCall featureCall) {
        ArrayList result = Lists.newArrayList();
        for (AbstractTypeComputationState component : this.components) {
            result.addAll(component.getLinkingCandidates(featureCall));
        }
        return result;
    }

    @Override
    public ITypeComputationState withExpectation(LightweightTypeReference expectation) {
        AbstractTypeComputationState[] result = new AbstractTypeComputationState[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            result[i] = this.components[i].withExpectation(expectation);
        }
        return new CompoundTypeComputationState(this.owner, result);
    }

    @Override
    public void refineExpectedType(XExpression expression, LightweightTypeReference expectation) {
        for (AbstractTypeComputationState component : this.components) {
            component.refineExpectedType(expression, expectation);
        }
    }

    @Override
    public ITypeComputationState withRootExpectation(LightweightTypeReference expectation) {
        AbstractTypeComputationState[] result = new AbstractTypeComputationState[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            result[i] = this.components[i].withRootExpectation(expectation);
        }
        return new CompoundTypeComputationState(this.owner, result);
    }

    @Override
    public ITypeComputationState withoutRootExpectation() {
        AbstractTypeComputationState[] result = new AbstractTypeComputationState[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            result[i] = this.components[i].withoutRootExpectation();
        }
        return new CompoundTypeComputationState(this.owner, result);
    }

    @Override
    public ITypeComputationState withNonVoidExpectation() {
        AbstractTypeComputationState[] result = new AbstractTypeComputationState[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            result[i] = this.components[i].withNonVoidExpectation();
        }
        return new CompoundTypeComputationState(this.owner, result);
    }

    @Override
    public ITypeComputationState withReturnExpectation() {
        AbstractTypeComputationState[] result = new AbstractTypeComputationState[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            result[i] = this.components[i].withReturnExpectation();
        }
        return new CompoundTypeComputationState(this.owner, result);
    }

    @Override
    public ITypeComputationState withoutExpectation() {
        AbstractTypeComputationState[] result = new AbstractTypeComputationState[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            result[i] = this.components[i].withoutExpectation();
        }
        return new CompoundTypeComputationState(this.owner, result);
    }

    @Override
    public ITypeComputationState withTypeCheckpoint(EObject context) {
        AbstractTypeComputationState[] result = new AbstractTypeComputationState[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            result[i] = this.components[i].withTypeCheckpoint(context);
        }
        return new CompoundTypeComputationState(this.owner, result);
    }

    @Override
    public ITypeComputationResult computeTypes(XExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("XExpression may not be null");
        }
        ExpressionAwareStackedResolvedTypes resolvedTypes = this.components[0].doComputeTypes(expression);
        int flags = resolvedTypes.getConformanceFlags(expression, false);
        for (int i = 1; i < this.components.length; ++i) {
            ExpressionAwareStackedResolvedTypes candidate = this.components[i].doComputeTypes(expression);
            int candidateFlags = candidate.getConformanceFlags(expression, false);
            int compareResult = this.compareFlags(flags, candidateFlags);
            if (compareResult != 1) continue;
            resolvedTypes = candidate;
            flags = candidateFlags;
        }
        resolvedTypes.performMergeIntoParent();
        ResolutionBasedComputationResult result = new ResolutionBasedComputationResult(expression, resolvedTypes.getParent());
        return result;
    }

    private int compareFlags(int leftConformance, int rightConformance) {
        int result = ConformanceFlags.compareFlags(leftConformance, rightConformance);
        if (result != 0) {
            return result;
        }
        if ((leftConformance & 0x80000) != (rightConformance & 0x80000)) {
            if ((leftConformance & 0x80000) != 0) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    @Override
    public ITypeComputationState assignType(JvmIdentifiableElement element, LightweightTypeReference type) {
        AbstractTypeComputationState[] result = new AbstractTypeComputationState[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            result[i] = this.components[i].assignType(element, type);
        }
        return new CompoundTypeComputationState(this.owner, result);
    }

    @Override
    public ITypeComputationState assignType(JvmIdentifiableElement element, LightweightTypeReference type, boolean addToChildScope) {
        AbstractTypeComputationState[] result = new AbstractTypeComputationState[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            result[i] = this.components[i].assignType(element, type, addToChildScope);
        }
        return new CompoundTypeComputationState(this.owner, result);
    }

    @Override
    public void addExtensionToCurrentScope(JvmIdentifiableElement extensionProvider) {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].addExtensionToCurrentScope(extensionProvider);
        }
    }

    @Override
    public void addTypeToStaticImportScope(JvmDeclaredType type) {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].addTypeToStaticImportScope(type);
        }
    }

    @Override
    public void addImports(ITypeImporter.Client importer) {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].addImports(importer);
        }
    }

    @Override
    public void addTypeToStaticExtensionImportScope(JvmDeclaredType type) {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].addTypeToStaticExtensionImportScope(type);
        }
    }

    @Override
    public void addExtensionsToCurrentScope(List<? extends JvmIdentifiableElement> extensionProviders) {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].addExtensionsToCurrentScope(extensionProviders);
        }
    }

    @Override
    public ITypeAssigner assignTypes() {
        TypeAssigner[] array = new TypeAssigner[this.components.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.components[i].assignTypes();
        }
        return new CompoundTypeAssigner(this.owner, array);
    }

    @Override
    public void addDiagnostic(AbstractDiagnostic diagnostic) {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].addDiagnostic(diagnostic);
        }
    }

    @Override
    public ITypeReferenceOwner getReferenceOwner() {
        return this.owner;
    }

    public LightweightTypeReference toLightweightTypeReference(JvmTypeReference reference) {
        return this.owner.toLightweightTypeReference(reference);
    }

    @Override
    public void addLocalToCurrentScope(JvmIdentifiableElement element) {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].addLocalToCurrentScope(element);
        }
    }

    @Override
    public void assignType(QualifiedName name, JvmType rawType, LightweightTypeReference actualType) {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].assignType(name, rawType, actualType);
        }
    }

    @Override
    public List<? extends ITypeExpectation> getExpectations() {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < this.components.length; ++i) {
            result.addAll(this.components[i].getExpectations());
        }
        return result;
    }

    @Override
    public void acceptCandidate(XExpression expression, IApplicableCandidate candidate) {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].acceptCandidate(expression, candidate);
        }
    }

    @Override
    public void acceptActualType(LightweightTypeReference type) {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].acceptActualType(type);
        }
    }

    @Override
    public void acceptActualType(LightweightTypeReference type, int flags) {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].acceptActualType(type, flags);
        }
    }

    @Override
    public void acceptActualType(LightweightTypeReference type, ConformanceHint ... hints) {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].acceptActualType(type, hints);
        }
    }

    @Override
    public void acceptActualType(LightweightTypeReference type, EnumSet<ConformanceHint> hints) {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].acceptActualType(type, hints);
        }
    }

    @Override
    public void reassignType(JvmIdentifiableElement refinable, LightweightTypeReference type) {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].reassignType(refinable, type);
        }
    }

    @Override
    public void discardReassignedTypes(JvmIdentifiableElement refinable) {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].discardReassignedTypes(refinable);
        }
    }

    @Override
    public UnboundTypeReference createUnboundTypeReference(XExpression expression, JvmTypeParameter typeParameter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<LightweightTypeReference> getExpectedExceptions() {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < this.components.length; ++i) {
            result.addAll(this.components[i].getExpectedExceptions());
        }
        return result;
    }

    @Override
    public ITypeComputationState withExpectedExceptions(List<LightweightTypeReference> declaredExceptionTypes) {
        AbstractTypeComputationState[] result = new AbstractTypeComputationState[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            result[i] = this.components[i].withExpectedExceptions((List)declaredExceptionTypes);
        }
        return new CompoundTypeComputationState(this.owner, result);
    }

    @Override
    public Severity getSeverity(String issueCode) {
        int n = 0;
        AbstractTypeComputationState[] abstractTypeComputationStateArray = this.components;
        int n2 = abstractTypeComputationStateArray.length;
        if (n < n2) {
            AbstractTypeComputationState state = abstractTypeComputationStateArray[n];
            return state.getSeverity(issueCode);
        }
        throw new IllegalStateException("no components available.");
    }

    @Override
    public boolean isIgnored(String issueCode) {
        int n = 0;
        AbstractTypeComputationState[] abstractTypeComputationStateArray = this.components;
        int n2 = abstractTypeComputationStateArray.length;
        if (n < n2) {
            AbstractTypeComputationState state = abstractTypeComputationStateArray[n];
            return state.isIgnored(issueCode);
        }
        throw new IllegalStateException("no components available.");
    }

    @Override
    public void withinScope(EObject context) {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].withinScope(context);
        }
    }

    @Override
    public void afterScope(EObject context) {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].afterScope(context);
        }
    }

    @Override
    public void rewriteScope(EObject context) {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].rewriteScope(context);
        }
    }
}

